/*
 * Decompiled with CFR 0.152.
 */
package org.bndtools.maven;

public class MavenVersion {
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String TSTAMP = "${tstamp}";
    private int major;
    private int minor;
    private int micro;
    private String qualifier;

    public MavenVersion(String versionString) throws IllegalArgumentException {
        int i;
        if (versionString == null) {
            this.micro = 0;
            this.minor = 0;
            this.major = 0;
            this.qualifier = null;
        } else {
            String main;
            int dashIndex = versionString.indexOf(45);
            if (dashIndex > -1) {
                main = versionString.substring(0, dashIndex);
                this.qualifier = versionString.substring(dashIndex + 1);
            } else {
                main = versionString;
                this.qualifier = null;
            }
            String[] segments = main.split("\\.", 3);
            this.major = segments.length > 0 ? Integer.parseInt(segments[0]) : 0;
            this.minor = segments.length > 1 ? Integer.parseInt(segments[1]) : 0;
            int n = this.micro = segments.length > 2 ? Integer.parseInt(segments[2]) : 0;
        }
        if (this.qualifier != null && (i = this.qualifier.indexOf(SNAPSHOT)) >= 0) {
            this.qualifier = this.qualifier.substring(0, i) + TSTAMP + this.qualifier.substring(i + SNAPSHOT.length());
        }
    }

    public String toBndVersion() {
        String s = String.format("%d.%d.%d", this.major, this.minor, this.micro);
        if (this.qualifier != null && this.qualifier.length() > 0) {
            s = s + "." + this.qualifier;
        }
        return s;
    }
}

