/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.plugin;

import aQute.bnd.header.OSGiHeader;
import aQute.bnd.maven.lib.configuration.BeanProperties;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.version.MavenVersion;
import aQute.bnd.version.Version;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.mapping.MappingUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="bnd-process", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BndMavenPlugin
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(BndMavenPlugin.class);
    private static final String MANIFEST_LAST_MODIFIED = "aQute.bnd.maven.plugin.BndMavenPlugin.manifestLastModified";
    private static final String MARKED_FILES = "aQute.bnd.maven.plugin.BndMavenPlugin.markedFiles";
    private static final String PACKAGING_JAR = "jar";
    private static final String PACKAGING_WAR = "war";
    private static final String TSTAMP = "${tstamp}";
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDir;
    @Parameter(defaultValue="${project.build.sourceDirectory}", readonly=true)
    private File sourceDir;
    @Parameter(defaultValue="${project.build.resources}", readonly=true)
    private List<Resource> resources;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDir;
    @Parameter(defaultValue="true")
    private boolean includeClassesDir;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File outputDir;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}")
    private File warOutputDir;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF")
    private File manifestPath;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojoExecution;
    @Parameter(property="bnd.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="bnd.packagingTypes", defaultValue="jar,war")
    private List<String> packagingTypes;
    @Parameter(defaultValue="bnd.bnd")
    private String bndfile;
    @Parameter
    private String bnd;
    @Component
    private BuildContext buildContext;
    private File propertiesFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            logger.debug("skip project as configured");
            return;
        }
        if (!this.packagingTypes.contains(this.project.getPackaging())) {
            logger.info("skip project with packaging=" + this.project.getPackaging());
            return;
        }
        BeanProperties beanProperties = new BeanProperties();
        beanProperties.put("project", this.project);
        beanProperties.put("settings", this.settings);
        Properties mavenProperties = new Properties((Properties)beanProperties);
        mavenProperties.putAll((Map<?, ?>)this.project.getProperties());
        try (Builder builder = new Builder(new Processor(mavenProperties, false));){
            builder.setTrace(logger.isDebugEnabled());
            builder.setBase(this.project.getBasedir());
            this.propertiesFile = this.loadProperties(builder);
            builder.setProperty("project.output", this.targetDir.getCanonicalPath());
            if (Processor.isTrue((String)builder.getProperty("-nobundles"))) {
                logger.debug("-nobundles: true");
                return;
            }
            List subs = builder.getSubBuilders();
            if (subs.size() != 1 || !builder.equals(subs.get(0))) {
                throw new MojoExecutionException("Sub-bundles not permitted in a maven build");
            }
            if (this.classesDir.isDirectory()) {
                builder.addClasspath(this.classesDir);
                Jar classesDirJar = new Jar(this.project.getName(), this.classesDir);
                if (!this.includeClassesDir) {
                    classesDirJar.removePrefix("");
                }
                classesDirJar.setManifest(new Manifest());
                builder.setJar(classesDirJar);
            }
            boolean isWab = PACKAGING_WAR.equals(this.project.getPackaging());
            boolean hasWablibs = builder.getProperty("-wablib") != null;
            String wabProperty = builder.getProperty("-wab");
            if (isWab) {
                if (wabProperty == null) {
                    builder.setProperty("-wab", "");
                }
                this.outputDir = this.warOutputDir;
                logger.info("WAB mode enabled. Bnd output will be expanded into the 'maven-war-plugin' <webappDirectory>:" + this.outputDir);
            } else if (wabProperty != null || hasWablibs) {
                throw new MojoFailureException("-wab & -wablib are not supported with packaging 'jar'");
            }
            Set artifacts = this.project.getArtifacts();
            ArrayList<Object> buildpath = new ArrayList<Object>(artifacts.size());
            ArrayList<String> wablibs = new ArrayList<String>(artifacts.size());
            for (Artifact artifact : artifacts) {
                File cpe = artifact.getFile().getCanonicalFile();
                if (!cpe.exists()) {
                    logger.debug("dependency {} does not exist", (Object)cpe);
                    continue;
                }
                if (cpe.isDirectory()) {
                    Jar cpeJar = new Jar(cpe);
                    builder.addClose((Closeable)cpeJar);
                    builder.updateModified(cpeJar.lastModified(), cpe.getPath());
                    buildpath.add(cpeJar);
                    continue;
                }
                if (!artifact.getType().equals(PACKAGING_JAR)) {
                    try (ZipFile zip = new ZipFile(cpe);){
                        zip.entries();
                    }
                    catch (ZipException e) {
                        logger.debug("dependency {} is not a zip", (Object)cpe);
                        continue;
                    }
                }
                builder.updateModified(cpe.lastModified(), cpe.getPath());
                buildpath.add(cpe);
                if (!isWab || hasWablibs || "provided".equals(artifact.getScope()) || "test".equals(artifact.getScope()) || artifact.isOptional()) continue;
                String fileNameMapping = MappingUtils.evaluateFileNameMapping((String)"@{artifactId}@-@{baseVersion}@.@{extension}@", (Artifact)artifact);
                wablibs.add("WEB-INF/lib/" + fileNameMapping + "=" + cpe.getName() + ";lib:=true");
            }
            if (!wablibs.isEmpty()) {
                String wablib = wablibs.stream().collect(Collectors.joining(","));
                builder.setProperty("-wablib", wablib);
            }
            builder.setProperty("project.buildpath", Strings.join((String)File.pathSeparator, buildpath));
            logger.debug("builder classpath: {}", (Object)builder.getProperty("project.buildpath"));
            boolean delta = !this.buildContext.isIncremental() || this.manifestOutOfDate();
            ArrayList<File> sourcepath = new ArrayList<File>();
            if (this.sourceDir.exists()) {
                sourcepath.add(this.sourceDir.getCanonicalFile());
                delta |= this.buildContext.hasDelta(this.sourceDir);
            }
            for (Resource resource : this.resources) {
                File resourceDir = new File(resource.getDirectory());
                if (!resourceDir.exists()) continue;
                sourcepath.add(resourceDir.getCanonicalFile());
                delta |= this.buildContext.hasDelta(resourceDir);
            }
            builder.setProperty("project.sourcepath", Strings.join((String)File.pathSeparator, sourcepath));
            logger.debug("builder sourcepath: {}", (Object)builder.getProperty("project.sourcepath"));
            if (builder.getProperty("Bundle-SymbolicName") == null) {
                builder.setProperty("Bundle-SymbolicName", this.project.getArtifactId());
            }
            if (builder.getProperty("Bundle-Name") == null) {
                builder.setProperty("Bundle-Name", this.project.getName());
            }
            if (builder.getProperty("Bundle-Version") == null) {
                Version version = MavenVersion.parseString((String)this.project.getVersion()).getOSGiVersion();
                builder.setProperty("Bundle-Version", version.toString());
                if (builder.getProperty("-snapshot") == null) {
                    builder.setProperty("-snapshot", TSTAMP);
                }
            }
            if (builder.getProperty("Bundle-Description") == null && StringUtils.isNotBlank((String)this.project.getDescription())) {
                StringBuilder description = new StringBuilder();
                OSGiHeader.quote((StringBuilder)description, (String)this.project.getDescription());
                builder.setProperty("Bundle-Description", description.toString());
            }
            if (builder.getProperty("Bundle-Vendor") == null && this.project.getOrganization() != null && StringUtils.isNotBlank((String)this.project.getOrganization().getName())) {
                builder.setProperty("Bundle-Vendor", this.project.getOrganization().getName());
            }
            if (builder.getProperty("Bundle-License") == null) {
                StringBuilder licenses = new StringBuilder();
                for (License license : this.project.getLicenses()) {
                    BndMavenPlugin.addHeaderValue(licenses, license.getName(), ',');
                    if (StringUtils.isNotBlank((String)license.getUrl())) {
                        BndMavenPlugin.addHeaderAttribute(licenses, "link", license.getUrl(), ';');
                    }
                    if (!StringUtils.isNotBlank((String)license.getComments())) continue;
                    BndMavenPlugin.addHeaderAttribute(licenses, "description", license.getComments(), ';');
                }
                if (licenses.length() > 0) {
                    builder.setProperty("Bundle-License", licenses.toString());
                }
            }
            if (builder.getProperty("Bundle-SCM") == null) {
                StringBuilder scm = new StringBuilder();
                if (this.project.getScm() != null) {
                    if (StringUtils.isNotBlank((String)this.project.getScm().getUrl())) {
                        BndMavenPlugin.addHeaderAttribute(scm, "url", this.project.getScm().getUrl(), ',');
                    }
                    if (StringUtils.isNotBlank((String)this.project.getScm().getConnection())) {
                        BndMavenPlugin.addHeaderAttribute(scm, "connection", this.project.getScm().getConnection(), ',');
                    }
                    if (StringUtils.isNotBlank((String)this.project.getScm().getDeveloperConnection())) {
                        BndMavenPlugin.addHeaderAttribute(scm, "developer-connection", this.project.getScm().getDeveloperConnection(), ',');
                    }
                    if (StringUtils.isNotBlank((String)this.project.getScm().getTag())) {
                        BndMavenPlugin.addHeaderAttribute(scm, "tag", this.project.getScm().getTag(), ',');
                    }
                    if (scm.length() > 0) {
                        builder.setProperty("Bundle-SCM", scm.toString());
                    }
                }
            }
            if (builder.getProperty("Bundle-Developers") == null) {
                StringBuilder developers = new StringBuilder();
                for (Developer developer : this.project.getDevelopers()) {
                    if (StringUtils.isNotBlank((String)developer.getId())) {
                        BndMavenPlugin.addHeaderValue(developers, developer.getId(), ',');
                        if (StringUtils.isNotBlank((String)developer.getEmail())) {
                            BndMavenPlugin.addHeaderAttribute(developers, "email", developer.getEmail(), ';');
                        }
                        if (StringUtils.isNotBlank((String)developer.getName())) {
                            BndMavenPlugin.addHeaderAttribute(developers, "name", developer.getName(), ';');
                        }
                        if (StringUtils.isNotBlank((String)developer.getOrganization())) {
                            BndMavenPlugin.addHeaderAttribute(developers, "organization", developer.getOrganization(), ';');
                        }
                        if (StringUtils.isNotBlank((String)developer.getOrganizationUrl())) {
                            BndMavenPlugin.addHeaderAttribute(developers, "organizationUrl", developer.getOrganizationUrl(), ';');
                        }
                        if (!developer.getRoles().isEmpty()) {
                            BndMavenPlugin.addHeaderAttribute(developers, "roles", StringUtils.join(developer.getRoles().iterator(), (String)","), ';');
                        }
                        if (!StringUtils.isNotBlank((String)developer.getTimezone())) continue;
                        BndMavenPlugin.addHeaderAttribute(developers, "timezone", developer.getTimezone(), ';');
                        continue;
                    }
                    logger.warn("Cannot consider developer in line '{}' of file '{}' for bundle header '{}' as it does not contain the mandatory id.", new Object[]{developer.getLocation((Object)"").getLineNumber(), developer.getLocation((Object)"").getSource().getLocation(), "Bundle-Developers"});
                }
                if (developers.length() > 0) {
                    builder.setProperty("Bundle-Developers", developers.toString());
                }
            }
            if (builder.getProperty("Bundle-DocURL") == null && StringUtils.isNotBlank((String)this.project.getUrl())) {
                builder.setProperty("Bundle-DocURL", this.project.getUrl());
            }
            logger.debug("builder properties: {}", (Object)builder.getProperties());
            logger.debug("builder delta: {}", (Object)delta);
            if (delta || builder.getJar() == null || builder.lastModified() > builder.getJar().lastModified()) {
                builder.setClasspath(buildpath);
                builder.setSourcepath(sourcepath.toArray(new File[0]));
                Jar bndJar = builder.build();
                this.expandJar(bndJar, this.outputDir);
            } else {
                logger.debug("No build");
            }
            this.reportErrorsAndWarnings(builder);
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("bnd error: " + e.getMessage(), e);
        }
    }

    private static StringBuilder addHeaderValue(StringBuilder builder, String value, char separator) {
        if (builder.length() > 0) {
            builder.append(separator);
        }
        OSGiHeader.quote((StringBuilder)builder, (String)value);
        return builder;
    }

    private static StringBuilder addHeaderAttribute(StringBuilder builder, String key, String value, char separator) {
        if (builder.length() > 0) {
            builder.append(separator);
        }
        builder.append(key).append("=");
        OSGiHeader.quote((StringBuilder)builder, (String)value);
        return builder;
    }

    private File loadProperties(Builder builder) throws Exception {
        this.loadParentProjectProperties(builder, this.project);
        Xpp3Dom configuration = Optional.ofNullable(this.project.getBuildPlugins()).flatMap(this::getConfiguration).orElseGet(this::defaultConfiguration);
        return this.loadProjectProperties(builder, this.project, this.project, configuration);
    }

    private void loadParentProjectProperties(Builder builder, MavenProject currentProject) throws Exception {
        MavenProject parentProject = currentProject.getParent();
        if (parentProject == null) {
            return;
        }
        this.loadParentProjectProperties(builder, parentProject);
        Xpp3Dom configuration = Optional.ofNullable(parentProject.getBuildPlugins()).flatMap(this::getConfiguration).orElse(null);
        if (configuration != null) {
            this.loadProjectProperties(builder, parentProject, parentProject, configuration);
            return;
        }
        configuration = Optional.ofNullable(currentProject.getPluginManagement()).map(PluginContainer::getPlugins).flatMap(this::getConfiguration).orElseGet(this::defaultConfiguration);
        this.loadProjectProperties(builder, parentProject, currentProject, configuration);
    }

    private File loadProjectProperties(Builder builder, MavenProject bndProject, MavenProject pomProject, Xpp3Dom configuration) throws Exception {
        Xpp3Dom bndElement;
        File pomFile;
        File baseDir = bndProject.getBasedir();
        if (baseDir != null) {
            pomFile = bndProject.getFile();
            builder.updateModified(pomFile.lastModified(), "POM: " + pomFile);
            Xpp3Dom bndfileElement = configuration.getChild("bndfile");
            String bndFileName = bndfileElement != null ? bndfileElement.getValue() : "bnd.bnd";
            File bndFile = IO.getFile((File)baseDir, (String)bndFileName);
            if (bndFile.isFile()) {
                logger.debug("loading bnd properties from file: {}", (Object)bndFile);
                builder.setProperties(bndFile.getParentFile(), builder.loadProperties(bndFile));
                return bndFile;
            }
        }
        baseDir = pomProject.getBasedir();
        pomFile = pomProject.getFile();
        if (baseDir != null) {
            builder.updateModified(pomFile.lastModified(), "POM: " + pomFile);
        }
        if ((bndElement = configuration.getChild("bnd")) != null) {
            logger.debug("loading bnd properties from bnd element in pom: {}", (Object)pomProject);
            UTF8Properties properties = new UTF8Properties();
            properties.load(bndElement.getValue(), pomFile, (Reporter)builder);
            builder.setProperties(baseDir, (Properties)properties.replaceHere(baseDir));
        }
        return pomFile;
    }

    private Optional<Xpp3Dom> getConfiguration(List<Plugin> plugins) {
        return plugins.stream().filter(p -> Objects.equals(p, this.mojoExecution.getPlugin())).map(Plugin::getExecutions).flatMap(Collection::stream).filter(e -> Objects.equals(e.getId(), this.mojoExecution.getExecutionId())).findFirst().map(ConfigurationContainer::getConfiguration).map(Xpp3Dom.class::cast).map(Xpp3Dom::new);
    }

    private Xpp3Dom defaultConfiguration() {
        return new Xpp3Dom("configuration");
    }

    private void reportErrorsAndWarnings(Builder builder) throws MojoFailureException {
        Collection<File> markedFiles = (HashSet)this.buildContext.getValue(MARKED_FILES);
        if (markedFiles == null) {
            this.buildContext.removeMessages(this.propertiesFile);
            markedFiles = builder.getIncluded();
        }
        if (markedFiles != null) {
            for (File file : markedFiles) {
                this.buildContext.removeMessages(file);
            }
        }
        markedFiles = new HashSet();
        List warnings = builder.getWarnings();
        for (String warning : warnings) {
            Report.Location location = builder.getLocation(warning);
            if (location == null) {
                location = new Report.Location();
                location.message = warning;
            }
            File f = location.file == null ? this.propertiesFile : new File(location.file);
            markedFiles.add(f);
            this.buildContext.addMessage(f, location.line, location.length, location.message, 1, null);
        }
        List list = builder.getErrors();
        for (String error : list) {
            Report.Location location = builder.getLocation(error);
            if (location == null) {
                location = new Report.Location();
                location.message = error;
            }
            File f = location.file == null ? this.propertiesFile : new File(location.file);
            markedFiles.add(f);
            this.buildContext.addMessage(f, location.line, location.length, location.message, 2, null);
        }
        this.buildContext.setValue(MARKED_FILES, markedFiles);
        if (!builder.isOk()) {
            if (list.size() == 1) {
                throw new MojoFailureException((String)list.get(0));
            }
            throw new MojoFailureException("Errors in bnd processing, see log for details.");
        }
    }

    private void expandJar(Jar jar, File dir) throws Exception {
        long lastModified = jar.lastModified();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Bundle lastModified: %tF %<tT.%<tL", lastModified));
        }
        dir = dir.getAbsoluteFile();
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        for (Map.Entry entry : jar.getResources().entrySet()) {
            FileResource fr;
            File outFile = IO.getBasedFile((File)dir, (String)((String)entry.getKey()));
            aQute.bnd.osgi.Resource resource = (aQute.bnd.osgi.Resource)entry.getValue();
            if (resource instanceof FileResource && outFile.equals((fr = (FileResource)resource).getFile()) || outFile.exists() && outFile.lastModified() >= lastModified) continue;
            if (logger.isDebugEnabled()) {
                if (outFile.exists()) {
                    logger.debug(String.format("Updating lastModified: %tF %<tT.%<tL '%s'", outFile.lastModified(), outFile));
                } else {
                    logger.debug("Creating '{}'", (Object)outFile);
                }
            }
            Files.createDirectories(outFile.toPath().getParent(), new FileAttribute[0]);
            OutputStream out = this.buildContext.newFileOutputStream(outFile);
            Throwable throwable = null;
            try {
                IO.copy((InputStream)resource.openInputStream(), (OutputStream)out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
        if (this.manifestOutOfDate() || this.manifestPath.lastModified() < lastModified) {
            if (logger.isDebugEnabled()) {
                if (!this.manifestOutOfDate()) {
                    logger.debug(String.format("Updating lastModified: %tF %<tT.%<tL '%s'", this.manifestPath.lastModified(), this.manifestPath));
                } else {
                    logger.debug("Creating '{}'", (Object)this.manifestPath);
                }
            }
            Files.createDirectories(this.manifestPath.toPath().getParent(), new FileAttribute[0]);
            try (OutputStream manifestOut = this.buildContext.newFileOutputStream(this.manifestPath);){
                jar.writeManifest(manifestOut);
            }
            this.buildContext.setValue(MANIFEST_LAST_MODIFIED, (Object)this.manifestPath.lastModified());
        }
    }

    private boolean manifestOutOfDate() {
        if (!this.manifestPath.isFile()) {
            return true;
        }
        long manifestLastModified = 0L;
        if (this.buildContext.getValue(MANIFEST_LAST_MODIFIED) != null) {
            manifestLastModified = (Long)this.buildContext.getValue(MANIFEST_LAST_MODIFIED);
        }
        return this.manifestPath.lastModified() != manifestLastModified;
    }
}

