/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.plugin;

import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.maven.PomPropertiesResource;
import aQute.bnd.maven.lib.configuration.BeanProperties;
import aQute.bnd.maven.lib.configuration.BndConfiguration;
import aQute.bnd.maven.lib.executions.PluginExecutions;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.version.MavenVersion;
import aQute.bnd.version.Version;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.service.reporter.Report;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.mapping.MappingUtils;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractBndMavenPlugin
extends AbstractMojo {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    static final String LAST_MODIFIED = "aQute.bnd.maven.plugin.BndMavenPlugin.lastModified";
    static final String MARKED_FILES = "aQute.bnd.maven.plugin.BndMavenPlugin.markedFiles";
    static final String PACKAGING_JAR = "jar";
    static final String PACKAGING_WAR = "war";
    static final String TSTAMP = "${tstamp}";
    static final String SNAPSHOT = "SNAPSHOT";
    @Parameter(defaultValue="true")
    boolean includeClassesDir;
    @Parameter(alias="warOutputDir", defaultValue="${project.build.directory}/${project.build.finalName}")
    File webappDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    String finalName;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    Settings settings;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    MojoExecution mojoExecution;
    @Parameter(property="bnd.packagingTypes", defaultValue="jar,war")
    List<String> packagingTypes;
    @Parameter(property="bnd.skipIfEmpty", defaultValue="false")
    boolean skipIfEmpty;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    String outputTimestamp;
    @Parameter(defaultValue="bnd.bnd")
    String bndfile;
    @Parameter
    String bnd;
    @Component
    BuildContext buildContext;
    @Component
    MavenProjectHelper projectHelper;
    @Component
    ArtifactHandlerManager artifactHandlerManager;
    File propertiesFile;

    public abstract File getSourceDir();

    public abstract List<Resource> getResources();

    public abstract File getClassesDir();

    public abstract File getOutputDir();

    public abstract File getManifestPath();

    public abstract boolean isSkip();

    public Optional<String> getClassifier() {
        return Optional.empty();
    }

    public Optional<String> getType() {
        return Optional.empty();
    }

    File getWebappDirectory() {
        return this.webappDirectory;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.packagingTypes.contains(this.project.getPackaging())) {
            this.logger.debug("skip project with packaging=" + this.project.getPackaging());
            return;
        }
        if (this.isSkip()) {
            this.logger.info("skip project as configured");
            return;
        }
        File classesDir = this.getClassesDir();
        if (this.skipIfEmpty && this.includeClassesDir && this.isEmpty(classesDir)) {
            this.logger.info("skip project because includeClassesDir=true, compiler output directory is empty and skipIfEmpty=true");
            return;
        }
        BeanProperties beanProperties = new BeanProperties();
        beanProperties.put("project", this.project);
        beanProperties.put("settings", this.settings);
        Properties mavenProperties = new Properties((Properties)beanProperties);
        Properties projectProperties = this.project.getProperties();
        Enumeration<?> propertyNames = projectProperties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            Object key = propertyNames.nextElement();
            mavenProperties.put(key, projectProperties.get(key));
        }
        try (Builder builder = new Builder(new Processor(mavenProperties, false));){
            String snapshot;
            boolean isReproducible;
            builder.setTrace(this.logger.isDebugEnabled());
            builder.setBase(this.project.getBasedir());
            this.propertiesFile = new BndConfiguration(this.project, this.mojoExecution).loadProperties((Processor)builder);
            builder.setProperty("project.output", this.getClassesDir().getCanonicalPath());
            if (Processor.isTrue((String)builder.getProperty("-nobundles"))) {
                this.logger.debug("-nobundles: true");
                return;
            }
            List subs = builder.getSubBuilders();
            if (subs.size() != 1 || !builder.equals(subs.get(0))) {
                throw new MojoExecutionException("Sub-bundles not permitted in a maven build");
            }
            if (classesDir.isDirectory()) {
                builder.addClasspath(classesDir);
                Jar classesDirJar = this.includeClassesDir ? new Jar(this.project.getName(), classesDir) : new Jar(this.project.getName());
                classesDirJar.setManifest(new Manifest());
                builder.setJar(classesDirJar);
            }
            boolean isWab = PACKAGING_WAR.equals(this.project.getPackaging());
            boolean hasWablibs = builder.getProperty("-wablib") != null;
            String wabProperty = builder.getProperty("-wab");
            if (isWab) {
                if (wabProperty == null) {
                    builder.setProperty("-wab", "");
                }
                this.logger.info("WAB mode enabled. Bnd output will be expanded into the 'maven-war-plugin' <webappDirectory>:" + this.getWebappDirectory());
            } else if (wabProperty != null || hasWablibs) {
                throw new MojoFailureException("-wab & -wablib are not supported with packaging 'jar'");
            }
            Set artifacts = this.project.getArtifacts();
            ArrayList<Object> buildpath = new ArrayList<Object>(artifacts.size());
            ArrayList<CallSite> wablibs = new ArrayList<CallSite>(artifacts.size());
            ScopeArtifactFilter scopeFilter = new ScopeArtifactFilter("runtime");
            for (Artifact artifact : artifacts) {
                File cpe = artifact.getFile().getCanonicalFile();
                if (!cpe.exists()) {
                    this.logger.debug("dependency {} does not exist", (Object)cpe);
                    continue;
                }
                if (cpe.isDirectory()) {
                    Jar cpeJar = new Jar(cpe);
                    cpeJar.setSource(new File(cpe.getParentFile(), this.createArtifactName(artifact)));
                    builder.addClose((AutoCloseable)cpeJar);
                    builder.updateModified(cpeJar.lastModified(), cpe.getPath());
                    buildpath.add(cpeJar);
                    continue;
                }
                if (!cpe.getName().endsWith(".jar")) {
                    try (ZipFile zip = new ZipFile(cpe);){
                        zip.entries();
                    }
                    catch (ZipException e) {
                        this.logger.debug("dependency {} is not a zip", (Object)cpe);
                        continue;
                    }
                }
                builder.updateModified(cpe.lastModified(), cpe.getPath());
                buildpath.add(cpe);
                if (!isWab || hasWablibs || artifact.isOptional() || !scopeFilter.include(artifact)) continue;
                String fileNameMapping = MappingUtils.evaluateFileNameMapping((String)"@{artifactId}@-@{baseVersion}@.@{extension}@", (Artifact)artifact);
                wablibs.add((CallSite)((Object)("WEB-INF/lib/" + fileNameMapping + "=" + cpe.getName() + ";lib:=true")));
            }
            if (!wablibs.isEmpty()) {
                String wablib = String.join((CharSequence)",", wablibs);
                builder.setProperty("-wablib", wablib);
            }
            this.processBuildPath(buildpath);
            builder.setProperty("project.buildpath", Strings.join((String)File.pathSeparator, buildpath));
            this.logger.debug("builder classpath: {}", (Object)builder.getProperty("project.buildpath"));
            boolean delta = !this.buildContext.isIncremental() || this.outOfDate();
            ArrayList<File> sourcepath = new ArrayList<File>();
            if (this.getSourceDir().exists()) {
                sourcepath.add(this.getSourceDir().getCanonicalFile());
                delta |= this.buildContext.hasDelta(this.getSourceDir());
            }
            for (Resource resource : this.getResources()) {
                File resourceDir = new File(resource.getDirectory());
                if (!resourceDir.exists()) continue;
                sourcepath.add(resourceDir.getCanonicalFile());
                delta |= this.buildContext.hasDelta(resourceDir);
            }
            builder.setProperty("project.sourcepath", Strings.join((String)File.pathSeparator, sourcepath));
            this.logger.debug("builder sourcepath: {}", (Object)builder.getProperty("project.sourcepath"));
            this.processBuilder(builder);
            boolean bl = isReproducible = Strings.nonNullOrEmpty((String)this.outputTimestamp) && (this.outputTimestamp.length() > 1 || Character.isDigit(this.outputTimestamp.charAt(0)));
            if (isReproducible) {
                builder.setProperty("-reproducible", this.outputTimestamp);
                if (builder.getProperty("-noextraheaders") == null) {
                    builder.setProperty("-noextraheaders", Boolean.TRUE.toString());
                }
            }
            if (builder.getProperty("Bundle-SymbolicName") == null) {
                builder.setProperty("Bundle-SymbolicName", this.project.getArtifactId());
            }
            if (builder.getProperty("Bundle-Name") == null) {
                builder.setProperty("Bundle-Name", this.project.getName());
            }
            String string = snapshot = isReproducible ? SNAPSHOT : null;
            if (builder.getProperty("Bundle-Version") == null) {
                Version version = new MavenVersion(this.project.getVersion()).getOSGiVersion();
                builder.setProperty("Bundle-Version", version.toString());
                if (snapshot == null) {
                    snapshot = TSTAMP;
                }
            }
            if (snapshot != null && builder.getProperty("-snapshot") == null) {
                builder.setProperty("-snapshot", snapshot);
            }
            if (builder.getProperty("Bundle-Description") == null && StringUtils.isNotBlank((String)this.project.getDescription())) {
                builder.setProperty("Bundle-Description", this.project.getDescription());
            }
            if (builder.getProperty("Bundle-Vendor") == null && this.project.getOrganization() != null && StringUtils.isNotBlank((String)this.project.getOrganization().getName())) {
                builder.setProperty("Bundle-Vendor", this.project.getOrganization().getName());
            }
            if (builder.getProperty("Bundle-License") == null) {
                StringBuilder licenses = new StringBuilder();
                for (License license : this.project.getLicenses()) {
                    AbstractBndMavenPlugin.addHeaderValue(licenses, license.getName(), ',');
                    if (StringUtils.isNotBlank((String)license.getUrl())) {
                        AbstractBndMavenPlugin.addHeaderAttribute(licenses, "link", license.getUrl(), ';');
                    }
                    if (!StringUtils.isNotBlank((String)license.getComments())) continue;
                    AbstractBndMavenPlugin.addHeaderAttribute(licenses, "description", license.getComments(), ';');
                }
                if (licenses.length() > 0) {
                    builder.setProperty("Bundle-License", licenses.toString());
                }
            }
            if (builder.getProperty("Bundle-SCM") == null) {
                StringBuilder scm = new StringBuilder();
                if (this.project.getScm() != null) {
                    if (StringUtils.isNotBlank((String)this.project.getScm().getUrl())) {
                        AbstractBndMavenPlugin.addHeaderAttribute(scm, "url", this.project.getScm().getUrl(), ',');
                    }
                    if (StringUtils.isNotBlank((String)this.project.getScm().getConnection())) {
                        AbstractBndMavenPlugin.addHeaderAttribute(scm, "connection", this.project.getScm().getConnection(), ',');
                    }
                    if (StringUtils.isNotBlank((String)this.project.getScm().getDeveloperConnection())) {
                        AbstractBndMavenPlugin.addHeaderAttribute(scm, "developer-connection", this.project.getScm().getDeveloperConnection(), ',');
                    }
                    if (StringUtils.isNotBlank((String)this.project.getScm().getTag())) {
                        AbstractBndMavenPlugin.addHeaderAttribute(scm, "tag", this.project.getScm().getTag(), ',');
                    }
                    if (scm.length() > 0) {
                        builder.setProperty("Bundle-SCM", scm.toString());
                    }
                }
            }
            if (builder.getProperty("Bundle-Developers") == null) {
                StringBuilder developers = new StringBuilder();
                for (Developer developer : this.project.getDevelopers()) {
                    if (StringUtils.isNotBlank((String)developer.getId())) {
                        AbstractBndMavenPlugin.addHeaderValue(developers, developer.getId(), ',');
                        if (StringUtils.isNotBlank((String)developer.getEmail())) {
                            AbstractBndMavenPlugin.addHeaderAttribute(developers, "email", developer.getEmail(), ';');
                        }
                        if (StringUtils.isNotBlank((String)developer.getName())) {
                            AbstractBndMavenPlugin.addHeaderAttribute(developers, "name", developer.getName(), ';');
                        }
                        if (StringUtils.isNotBlank((String)developer.getOrganization())) {
                            AbstractBndMavenPlugin.addHeaderAttribute(developers, "organization", developer.getOrganization(), ';');
                        }
                        if (StringUtils.isNotBlank((String)developer.getOrganizationUrl())) {
                            AbstractBndMavenPlugin.addHeaderAttribute(developers, "organizationUrl", developer.getOrganizationUrl(), ';');
                        }
                        if (!developer.getRoles().isEmpty()) {
                            AbstractBndMavenPlugin.addHeaderAttribute(developers, "roles", StringUtils.join(developer.getRoles().iterator(), (String)","), ';');
                        }
                        if (!StringUtils.isNotBlank((String)developer.getTimezone())) continue;
                        AbstractBndMavenPlugin.addHeaderAttribute(developers, "timezone", developer.getTimezone(), ';');
                        continue;
                    }
                    this.logger.warn("Cannot consider developer in line '{}' of file '{}' for bundle header '{}' as it does not contain the mandatory id.", new Object[]{developer.getLocation((Object)"").getLineNumber(), developer.getLocation((Object)"").getSource().getLocation(), "Bundle-Developers"});
                }
                if (developers.length() > 0) {
                    builder.setProperty("Bundle-Developers", developers.toString());
                }
            }
            if (builder.getProperty("Bundle-DocURL") == null && StringUtils.isNotBlank((String)this.project.getUrl())) {
                builder.setProperty("Bundle-DocURL", this.project.getUrl());
            }
            this.logger.debug("builder properties: {}", (Object)builder.getProperties());
            this.logger.debug("builder delta: {}", (Object)delta);
            if (delta || builder.getJar() == null || builder.lastModified() > builder.getJar().lastModified()) {
                builder.setClasspath(buildpath);
                builder.setSourcepath(sourcepath.toArray(new File[0]));
                Jar bndJar = builder.build();
                String goal = this.mojoExecution.getMojoDescriptor().getGoal();
                if (PluginExecutions.isPackagingGoal((String)goal)) {
                    if (!this.mojoExecution.getPlugin().isExtensions()) {
                        throw new MojoExecutionException(String.format("In order to use the bnd-maven-plugin packaging goal %s, <extensions>true</extensions> must be set on the plugin", goal));
                    }
                    if (isWab) {
                        outputDirectory = this.getWebappDirectory();
                        this.writeContent(bndJar, outputDirectory);
                        File manifestPath = new File(outputDirectory, bndJar.getManifestName());
                        this.writeManifest(bndJar, manifestPath);
                    }
                    this.addMavenMetadataToJar(bndJar);
                    this.attachArtifactToProject(bndJar);
                } else {
                    outputDirectory = isWab ? this.getWebappDirectory() : this.getOutputDir();
                    this.writeContent(bndJar, outputDirectory);
                    this.writeManifest(bndJar, this.getManifestPath());
                }
            } else {
                this.logger.debug("No build");
            }
            this.reportErrorsAndWarnings(builder);
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("bnd error: " + e.getMessage(), e);
        }
    }

    protected void processBuilder(Builder builder) throws MojoFailureException {
    }

    protected void processBuildPath(List<Object> buildpath) {
    }

    private static StringBuilder addHeaderValue(StringBuilder builder, String value, char separator) {
        if (builder.length() > 0) {
            builder.append(separator);
        }
        OSGiHeader.quote((StringBuilder)builder, (String)value);
        return builder;
    }

    private static StringBuilder addHeaderAttribute(StringBuilder builder, String key, String value, char separator) {
        if (builder.length() > 0) {
            builder.append(separator);
        }
        builder.append(key).append("=");
        OSGiHeader.quote((StringBuilder)builder, (String)value);
        return builder;
    }

    private void attachArtifactToProject(Jar bndJar) throws Exception {
        Optional<String> classifier;
        File artifactFile = this.getArtifactFile();
        if (this.outOfDate(artifactFile) || artifactFile.lastModified() < bndJar.lastModified()) {
            if (this.logger.isDebugEnabled()) {
                if (artifactFile.exists()) {
                    this.logger.debug(String.format("Updating lastModified: %tF %<tT.%<tL '%s'", artifactFile.lastModified(), artifactFile));
                } else {
                    this.logger.debug("Creating '{}'", (Object)artifactFile);
                }
            }
            Files.createDirectories(artifactFile.toPath().getParent(), new FileAttribute[0]);
            try (OutputStream os = this.buildContext.newFileOutputStream(artifactFile);){
                bndJar.write(os);
            }
            this.buildContext.setValue(LAST_MODIFIED, (Object)artifactFile.lastModified());
        }
        if ((classifier = this.getClassifier()).isPresent()) {
            this.projectHelper.attachArtifact(this.project, this.getType().orElse(""), classifier.get(), artifactFile);
        } else {
            Artifact artifact = this.project.getArtifact();
            if (Optional.ofNullable(artifact.getFile()).map(File::isFile).orElse(Boolean.FALSE).booleanValue()) {
                this.logger.warn("The main artifact on {} was already set. It will be replaced by {}", (Object)this.project, (Object)this.mojoExecution);
            }
            artifact.setFile(artifactFile);
        }
    }

    private void addMavenMetadataToJar(Jar bndJar) throws IOException {
        String groupId = this.project.getGroupId();
        String artifactId = this.project.getArtifactId();
        String version = this.project.getArtifact().isSnapshot() ? this.project.getArtifact().getVersion() : this.project.getVersion();
        bndJar.putResource(String.format("META-INF/maven/%s/%s/pom.xml", groupId, artifactId), (aQute.bnd.osgi.Resource)new FileResource(this.project.getFile()));
        PomPropertiesResource pomProperties = new PomPropertiesResource(groupId, artifactId, version);
        bndJar.putResource(pomProperties.getWhere(), (aQute.bnd.osgi.Resource)pomProperties);
    }

    private File getArtifactFile() {
        return new File(this.getOutputDir(), this.finalName + this.getClassifier().map("-"::concat).orElse("") + "." + this.getExtension(this.project.getPackaging()));
    }

    private String getExtension(String type) {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(type);
        if (artifactHandler != null) {
            return artifactHandler.getExtension();
        }
        return type;
    }

    private String createArtifactName(Artifact artifact) {
        String classifier = artifact.getClassifier();
        if (classifier == null || classifier.isEmpty()) {
            return String.format("%s-%s.%s", artifact.getArtifactId(), artifact.getVersion(), this.getExtension(artifact.getType()));
        }
        return String.format("%s-%s-%s.%s", artifact.getArtifactId(), artifact.getVersion(), classifier, this.getExtension(artifact.getType()));
    }

    protected void reportErrorsAndWarnings(Builder builder) throws MojoFailureException {
        Collection<File> markedFiles = (HashSet)this.buildContext.getValue(MARKED_FILES);
        if (markedFiles == null) {
            this.buildContext.removeMessages(this.propertiesFile);
            markedFiles = builder.getIncluded();
        }
        if (markedFiles != null) {
            for (File file : markedFiles) {
                this.buildContext.removeMessages(file);
            }
        }
        markedFiles = new HashSet();
        List warnings = builder.getWarnings();
        for (String warning : warnings) {
            Report.Location location = builder.getLocation(warning);
            if (location == null) {
                location = new Report.Location();
                location.message = warning;
            }
            File f = location.file == null ? this.propertiesFile : new File(location.file);
            markedFiles.add(f);
            this.buildContext.addMessage(f, location.line, location.length, location.message, 1, null);
        }
        List list = builder.getErrors();
        for (String error : list) {
            Report.Location location = builder.getLocation(error);
            if (location == null) {
                location = new Report.Location();
                location.message = error;
            }
            File f = location.file == null ? this.propertiesFile : new File(location.file);
            markedFiles.add(f);
            this.buildContext.addMessage(f, location.line, location.length, location.message, 2, null);
        }
        this.buildContext.setValue(MARKED_FILES, markedFiles);
        if (!builder.isOk()) {
            if (list.size() == 1) {
                throw new MojoFailureException((String)list.get(0));
            }
            throw new MojoFailureException("Errors in bnd processing, see log for details.");
        }
    }

    protected boolean isEmpty(File directory) {
        boolean bl;
        block9: {
            if (directory == null || !directory.isDirectory()) {
                return true;
            }
            Path path = directory.toPath();
            Path meta_inf = Paths.get("META-INF", new String[0]);
            Stream<Path> entries = Files.walk(path, new FileVisitOption[0]);
            try {
                bl = entries.allMatch(p -> Files.isDirectory(p, new LinkOption[0]) || path.relativize((Path)p).startsWith(meta_inf));
                if (entries == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (entries != null) {
                        try {
                            entries.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw Exceptions.duck((Throwable)ioe);
                }
            }
            entries.close();
        }
        return bl;
    }

    private void writeContent(Jar jar, File directory) throws Exception {
        long lastModified = jar.lastModified();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Bundle lastModified: %tF %<tT.%<tL", lastModified));
        }
        directory = directory.getAbsoluteFile();
        Files.createDirectories(directory.toPath(), new FileAttribute[0]);
        for (Map.Entry entry : jar.getResources().entrySet()) {
            FileResource fileResource;
            File outFile = IO.getBasedFile((File)directory, (String)((String)entry.getKey()));
            aQute.bnd.osgi.Resource resource = (aQute.bnd.osgi.Resource)entry.getValue();
            if (resource instanceof FileResource && outFile.equals((fileResource = (FileResource)resource).getFile()) || outFile.exists() && outFile.lastModified() >= lastModified) continue;
            if (this.logger.isDebugEnabled()) {
                if (outFile.exists()) {
                    this.logger.debug(String.format("Updating lastModified: %tF %<tT.%<tL '%s'", outFile.lastModified(), outFile));
                } else {
                    this.logger.debug("Creating '{}'", (Object)outFile);
                }
            }
            Files.createDirectories(outFile.toPath().getParent(), new FileAttribute[0]);
            OutputStream out = this.buildContext.newFileOutputStream(outFile);
            try {
                IO.copy((InputStream)resource.openInputStream(), (OutputStream)out);
            }
            finally {
                if (out == null) continue;
                out.close();
            }
        }
    }

    private void writeManifest(Jar jar, File manifestPath) throws Exception {
        long lastModified = jar.lastModified();
        if (this.outOfDate(manifestPath) || manifestPath.lastModified() < lastModified) {
            if (this.logger.isDebugEnabled()) {
                if (!this.outOfDate(manifestPath)) {
                    this.logger.debug(String.format("Updating lastModified: %tF %<tT.%<tL '%s'", manifestPath.lastModified(), manifestPath));
                } else {
                    this.logger.debug("Creating '{}'", (Object)manifestPath);
                }
            }
            Files.createDirectories(manifestPath.toPath().getParent(), new FileAttribute[0]);
            try (OutputStream manifestOut = this.buildContext.newFileOutputStream(manifestPath);){
                jar.writeManifest(manifestOut);
            }
            this.buildContext.setValue(LAST_MODIFIED, (Object)manifestPath.lastModified());
        }
    }

    private boolean outOfDate() {
        String goal = this.mojoExecution.getMojoDescriptor().getGoal();
        return this.outOfDate(PluginExecutions.isPackagingGoal((String)goal) ? this.getArtifactFile() : this.getManifestPath());
    }

    private boolean outOfDate(File target) {
        if (!target.isFile()) {
            return true;
        }
        long lastModified = 0L;
        if (this.buildContext.getValue(LAST_MODIFIED) != null) {
            lastModified = (Long)this.buildContext.getValue(LAST_MODIFIED);
        }
        return target.lastModified() != lastModified;
    }
}

