/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.resolver.plugin;

import aQute.bnd.build.Container;
import aQute.bnd.header.Parameters;
import aQute.bnd.maven.lib.configuration.Bndruns;
import aQute.bnd.maven.lib.configuration.Bundles;
import aQute.bnd.maven.lib.resolve.BndrunContainer;
import aQute.bnd.maven.lib.resolve.Operation;
import aQute.bnd.maven.lib.resolve.Scope;
import aQute.bnd.osgi.repository.ResourcesRepository;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.unmodifiable.Sets;
import aQute.bnd.version.VersionRange;
import aQute.service.reporter.Reporter;
import biz.aQute.resolve.Bndrun;
import biz.aQute.resolve.ResolutionCallback;
import biz.aQute.resolve.ResolveProcess;
import biz.aQute.resolve.RunResolution;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.resolver.ResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="verify", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class VerifierMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(VerifierMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repositorySession;
    @Parameter
    private Bndruns bndruns = new Bndruns();
    @Parameter
    private Bundles bundles = new Bundles();
    @Parameter(defaultValue="true")
    private boolean useMavenDependencies;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDir;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="bnd.resolve.include.dependency.management", defaultValue="false")
    private boolean includeDependencyManagement;
    @Parameter(defaultValue="true")
    private boolean reportOptional;
    @Parameter(property="bnd.resolve.scopes", defaultValue="compile,runtime")
    private Set<Scope> scopes = Sets.of((Object)Scope.compile, (Object)Scope.runtime);
    @Parameter(property="bnd.resolve.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project.basedir}")
    private File bndrunDir;
    @Component
    private RepositorySystem system;
    @Component
    private ProjectDependenciesResolver resolver;
    @Component
    private ArtifactFactory artifactFactory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            logger.debug("skip project as configured");
            return;
        }
        int errors = 0;
        try {
            List bndrunFiles = this.bndruns.getFiles(this.bndrunDir, new String[]{"*.bndrun"});
            if (bndrunFiles.isEmpty()) {
                logger.warn("No bndrun files were specified with <bndrun> or found as *.bndrun in the project. This is unexpected.");
                return;
            }
            BndrunContainer container = new BndrunContainer.Builder(this.project, this.session, this.repositorySession, this.resolver, this.artifactFactory, this.system).setBundles(this.bundles.getFiles(this.project.getBasedir(), new String[0])).setIncludeDependencyManagement(this.includeDependencyManagement).setScopes(this.scopes).setUseMavenDependencies(this.useMavenDependencies).build();
            Operation operation = this.getOperation();
            for (File runFile : bndrunFiles) {
                logger.info("Verifying {}:", (Object)runFile);
                errors += container.execute(runFile, "resolve", this.targetDir, operation);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (errors > 0) {
            throw new MojoFailureException(errors + " errors found");
        }
    }

    private Operation getOperation() {
        return (file, runName, run) -> {
            try {
                String originalRunRequires = run.mergeProperties("-runrequires");
                Collection expectedRunbundles = run.getRunbundles().stream().map(Container::getBundleId).collect(Collectors.toList());
                List<Requirement> runBundleReqs = expectedRunbundles.stream().map(c -> CapReqBuilder.createBundleRequirement((String)c.getBsn(), (String)new VersionRange(c.getVersion(), c.getVersion()).toString()).buildSyntheticRequirement()).collect(Collectors.toList());
                run.setRunRequires(runBundleReqs.stream().map(Object::toString).collect(Collectors.joining(", ")));
                RunResolution result = run.resolve(new ResolutionCallback[]{new BundleFilter(runBundleReqs)});
                if (result.isOK()) {
                    List resolved = result.getResolvedRunBundles();
                    List missing = expectedRunbundles.stream().filter(c -> !resolved.contains(c)).collect(Collectors.toList());
                    List extra = resolved.stream().filter(c -> !expectedRunbundles.contains(c)).collect(Collectors.toList());
                    if (missing.isEmpty() && extra.isEmpty()) {
                        Parameters inputRequirements = new Parameters(originalRunRequires, (Reporter)run);
                        List resolvedResources = result.getOrderedResources();
                        List unmatchedInitialRequirements = CapReqBuilder.getRequirementsFrom((Parameters)inputRequirements).stream().filter(req -> resolvedResources.stream().noneMatch(res -> ResourceUtils.matches((Requirement)req, (Resource)res))).collect(Collectors.toList());
                        if (unmatchedInitialRequirements.isEmpty()) {
                            logger.info("The bndrun file {} validated successfully", (Object)file);
                        } else {
                            logger.error("The bndrun file {} failed validation with {} unmatched initial requirements", (Object)file, unmatchedInitialRequirements);
                            run.error("Bndrun resolution verification failed for file %s.\nThe following initial requirements were not satisfied: %s", new Object[]{file, unmatchedInitialRequirements});
                        }
                    } else {
                        logger.error("The bndrun file {} failed validation with {} missing bundles and {} extra bundles", new Object[]{file, missing, extra});
                        run.error("Bndrun resolution verification failed for file %s.\nThe missing results were: %s\nThe extra bundles were: %s", new Object[]{file, missing, extra});
                    }
                } else if (result.exception instanceof ResolutionException) {
                    String msg = ResolveProcess.format((ResolutionException)((ResolutionException)((Object)((Object)result.exception))), (boolean)this.reportOptional);
                    logger.error(msg);
                    run.error(msg, new Object[0]);
                } else {
                    logger.error("An unknown error ocurred verifying bndrun file {}", (Object)file, (Object)result.exception);
                    run.error("An unknown error ocurred verifying bndrun file %s", (Throwable)result.exception, new Object[]{file});
                }
            }
            finally {
                int errors = BndrunContainer.report((Bndrun)run);
                if (errors > 0) {
                    return errors;
                }
            }
            return 0;
        };
    }

    private static class BundleFilter
    implements ResolutionCallback {
        private final List<Requirement> bundleRequirements;
        private final ResourcesRepository repo = new ResourcesRepository();

        public BundleFilter(List<Requirement> bundleRequirements) {
            this.bundleRequirements = bundleRequirements;
        }

        public void processCandidates(Requirement requirement, Set<Capability> wired, List<Capability> candidates) {
            Iterator<Capability> it = candidates.iterator();
            while (it.hasNext()) {
                Resource resource = it.next().getResource();
                if (this.repo.contains(resource)) continue;
                ResourceUtils.IdentityCapability id = ResourceUtils.getIdentityCapability((Resource)resource);
                if (this.bundleRequirements.stream().noneMatch(arg_0 -> BundleFilter.lambda$processCandidates$0((Capability)id, arg_0))) {
                    it.remove();
                    continue;
                }
                this.repo.add(resource);
            }
        }

        private static /* synthetic */ boolean lambda$processCandidates$0(Capability id, Requirement r) {
            return ResourceUtils.matches((Requirement)r, (Capability)id);
        }
    }
}

