/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.run.plugin;

import aQute.bnd.build.ProjectLauncher;
import aQute.bnd.maven.lib.configuration.Bundles;
import aQute.bnd.maven.lib.resolve.BndrunContainer;
import aQute.bnd.maven.lib.resolve.Operation;
import aQute.bnd.maven.lib.resolve.Scope;
import aQute.bnd.unmodifiable.Sets;
import biz.aQute.resolve.Bndrun;
import java.io.File;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="run", defaultPhase=LifecyclePhase.PACKAGE, requiresDirectInvocation=true, requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class RunMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(RunMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repositorySession;
    @Parameter(property="bnd.run.file")
    private File bndrun;
    @Parameter(required=false)
    private Bundles bundles = new Bundles();
    @Parameter(defaultValue="true")
    private boolean useMavenDependencies;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="bnd.run.scopes", defaultValue="compile,runtime")
    private Set<Scope> scopes = Sets.of((Object)Scope.compile, (Object)Scope.runtime);
    @Parameter(property="bnd.run.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="bnd.run.include.dependency.management", defaultValue="false")
    private boolean includeDependencyManagement;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDir;
    @Component
    private RepositorySystem system;
    @Component
    private ProjectDependenciesResolver resolver;
    @Component
    private ArtifactFactory artifactFactory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Operation operation;
        BndrunContainer container;
        if (this.skip) {
            logger.debug("skip project as configured");
            return;
        }
        if (this.bndrun == null) {
            logger.info("Nothing to run.");
            return;
        }
        int errors = 0;
        try {
            container = new BndrunContainer.Builder(this.project, this.session, this.repositorySession, this.resolver, this.artifactFactory, this.system).setBundles(this.bundles.getFiles(this.project.getBasedir(), new String[0])).setIncludeDependencyManagement(this.includeDependencyManagement).setScopes(this.scopes).setUseMavenDependencies(this.useMavenDependencies).build();
            operation = this.getOperation();
            logger.info("Running {}:", (Object)this.bndrun);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if ((errors += container.execute(this.bndrun, "run", this.targetDir, operation)) > 0) {
            throw new MojoFailureException(errors + " errors found");
        }
    }

    private Operation getOperation() {
        return (file, runName, run) -> {
            ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            try (ProjectLauncher pl = run.getProjectLauncher();
                 ProjectLauncher.LiveCoding liveCoding = pl.liveCoding((Executor)ForkJoinPool.commonPool(), scheduledExecutor);){
                pl.setTrace(run.isTrace() || run.isRunTrace());
                pl.launch();
            }
            finally {
                scheduledExecutor.shutdownNow();
                int errors = BndrunContainer.report((Bndrun)run);
                if (errors > 0) {
                    return errors;
                }
            }
            return 0;
        };
    }
}

