/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.testing.plugin;

import aQute.bnd.maven.lib.configuration.Bndruns;
import aQute.bnd.maven.lib.configuration.Bundles;
import aQute.bnd.maven.lib.resolve.BndrunContainer;
import aQute.bnd.maven.lib.resolve.Operation;
import aQute.bnd.maven.lib.resolve.Scope;
import aQute.bnd.unmodifiable.Sets;
import aQute.lib.strings.Strings;
import aQute.libg.glob.Glob;
import biz.aQute.resolve.Bndrun;
import biz.aQute.resolve.ResolveProcess;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.settings.Settings;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.osgi.service.resolver.ResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="testing", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class TestingMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(TestingMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repositorySession;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="bnd.testing.failure.ignore", defaultValue="false")
    private boolean testFailureIgnore;
    @Parameter
    private Bndruns bndruns = new Bndruns();
    @Parameter(defaultValue="${project.build.directory}/test", readonly=true)
    private File cwd;
    @Parameter(defaultValue="${project.build.directory}/test-reports", readonly=true)
    private File reportsDir;
    @Parameter(defaultValue="${testing.select}", readonly=true)
    private File testingSelect;
    @Parameter(defaultValue="${testing}", readonly=true)
    private String testing;
    @Parameter(property="test")
    private String test;
    @Parameter(required=false)
    private Bundles bundles = new Bundles();
    @Parameter(defaultValue="true")
    private boolean useMavenDependencies;
    @Parameter(defaultValue="false")
    private boolean resolve;
    @Parameter(defaultValue="true")
    private boolean reportOptional;
    @Parameter(defaultValue="true")
    private boolean failOnChanges;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="bnd.testing.scopes", defaultValue="compile,runtime")
    private Set<Scope> scopes = Sets.of((Object)Scope.compile, (Object)Scope.runtime);
    @Parameter(property="bnd.testing.include.dependency.management", defaultValue="false")
    private boolean includeDependencyManagement;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDir;
    @Parameter(defaultValue="${project.basedir}")
    private File bndrunDir;
    @Component
    private RepositorySystem system;
    @Component
    private ProjectDependenciesResolver resolver;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ToolchainManager toolchainManager;
    private Glob glob = new Glob("*");

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipTests) {
            logger.debug("skip project as configured");
            return;
        }
        if (this.testingSelect != null) {
            logger.info("Using selected testing file {}", (Object)this.testingSelect);
            this.bndruns = new Bndruns();
            this.bndruns.setBndrun(this.testingSelect);
        } else {
            this.glob = new Glob(this.testing == null ? "*" : this.testing);
            logger.info("Matching glob {}", (Object)this.glob);
        }
        int errors = 0;
        try {
            List bndrunFiles = this.bndruns.getFiles(this.bndrunDir, new String[]{"*.bndrun"});
            if (bndrunFiles.isEmpty()) {
                logger.warn("No bndrun files were specified with <bndrun> or found as *.bndrun in the project. This is unexpected.");
                return;
            }
            BndrunContainer container = new BndrunContainer.Builder(this.project, this.session, this.repositorySession, this.resolver, this.artifactFactory, this.system).setBundles(this.bundles.getFiles(this.project.getBasedir(), new String[0])).setIncludeDependencyManagement(this.includeDependencyManagement).setScopes(this.scopes).setUseMavenDependencies(this.useMavenDependencies).build();
            Operation operation = this.getOperation();
            for (File runFile : bndrunFiles) {
                logger.info("Testing {}:", (Object)runFile);
                errors += container.execute(runFile, "testing", this.cwd, operation);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (!this.isTestFailureIgnore() && errors > 0) {
            throw new MojoFailureException(errors + " errors found");
        }
    }

    private List<String> getTests() {
        logger.debug("getTests: {}", (Object)this.test);
        if (this.test == null || this.test.trim().isEmpty()) {
            return null;
        }
        return Strings.split((String)this.test);
    }

    private boolean isTestFailureIgnore() {
        return this.testFailureIgnore;
    }

    private Operation getOperation() {
        return (file, bndrun, run) -> {
            if (!this.glob.matcher((CharSequence)file.getName()).matches()) {
                logger.info("Skipping {}", (Object)bndrun);
                return 0;
            }
            if (this.resolve) {
                try {
                    String runBundles = run.resolve(this.failOnChanges, false);
                    if (run.isOk()) {
                        logger.info("{}: {}", (Object)"-runbundles", (Object)runBundles);
                        run.setProperty("-runbundles", runBundles);
                    }
                }
                catch (ResolutionException re) {
                    logger.error(ResolveProcess.format((ResolutionException)re, (boolean)this.reportOptional));
                    throw re;
                }
                finally {
                    int errors = BndrunContainer.report((Bndrun)run);
                    if (errors > 0) {
                        return errors;
                    }
                }
            }
            this.getToolchainJavaHome().ifPresent(home -> run.setProperty("java", home + File.separatorChar + "bin" + File.separatorChar + "java"));
            try {
                run.test(new File(this.reportsDir, bndrun), this.getTests());
            }
            finally {
                int errors = BndrunContainer.report((Bndrun)run);
                if (errors > 0) {
                    return errors;
                }
            }
            return 0;
        };
    }

    private Optional<String> getToolchainJavaHome() {
        return Optional.ofNullable(this.toolchainManager).map(tm -> tm.getToolchainFromBuildContext("jdk", this.session)).filter(DefaultJavaToolChain.class::isInstance).map(DefaultJavaToolChain.class::cast).map(DefaultJavaToolChain::getJavaHome);
    }
}

