/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.lambdaworks.redis.ChannelGroupListener;
import com.lambdaworks.redis.ConnectionEventTrigger;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.FutureSyncInvocationHandler;
import com.lambdaworks.redis.RedisAsyncConnectionImpl;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisConnectionException;
import com.lambdaworks.redis.RedisConnectionStateListener;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.protocol.ConnectionWatchdog;
import com.lambdaworks.redis.pubsub.PubSubCommandHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.internal.ConcurrentSet;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.lang.reflect.Proxy;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class AbstractRedisClient {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisClient.class);
    private static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)(Runtime.getRuntime().availableProcessors() * 4)));
    protected EventLoopGroup eventLoopGroup;
    protected HashedWheelTimer timer;
    protected ChannelGroup channels;
    protected long timeout;
    protected TimeUnit unit;
    protected ConnectionEvents connectionEvents = new ConnectionEvents();
    protected Set<Closeable> closeableResources = new ConcurrentSet();

    protected AbstractRedisClient() {
        this.timer = new HashedWheelTimer();
        this.eventLoopGroup = new NioEventLoopGroup(DEFAULT_EVENT_LOOP_THREADS);
        this.channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.timer.start();
    }

    public void setDefaultTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    protected <K, V, T extends RedisAsyncConnectionImpl<K, V>> T connectAsyncImpl(final CommandHandler<K, V> handler, final T connection, Supplier<SocketAddress> socketAddressSupplier, final boolean withReconnect) {
        try {
            SocketAddress redisAddress = (SocketAddress)socketAddressSupplier.get();
            logger.debug("Connecting to Redis, address: " + redisAddress);
            Bootstrap redisBootstrap = (Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group(this.eventLoopGroup);
            redisBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)this.unit.toMillis(this.timeout)));
            final ConnectionWatchdog watchdog = new ConnectionWatchdog(redisBootstrap, (Timer)this.timer, socketAddressSupplier);
            redisBootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    if (withReconnect) {
                        watchdog.setReconnect(true);
                        ch.pipeline().addLast(new ChannelHandler[]{watchdog});
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelGroupListener(AbstractRedisClient.this.channels), new ConnectionEventTrigger(AbstractRedisClient.this.connectionEvents, connection), handler, connection});
                }
            });
            ChannelFuture future = redisBootstrap.connect(redisAddress);
            future.await();
            if (!future.isSuccess()) {
                if (future.cause() instanceof Exception) {
                    throw (Exception)future.cause();
                }
                future.get();
            }
            connection.registerCloseables(this.closeableResources, connection, handler);
            return connection;
        }
        catch (Exception e) {
            connection.close();
            throw new RedisConnectionException("Unable to connect", e);
        }
    }

    public void shutdown() {
        this.shutdown(2L, 15L, TimeUnit.SECONDS);
    }

    public void shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        while (!this.closeableResources.isEmpty()) {
            Closeable closeableResource = this.closeableResources.iterator().next();
            try {
                closeableResource.close();
            }
            catch (Exception e) {
                logger.debug("Exception on Close: " + e.getMessage(), (Throwable)e);
            }
            this.closeableResources.remove(closeableResource);
        }
        for (Channel c : this.channels) {
            PubSubCommandHandler psCommandHandler;
            ChannelPipeline pipeline = c.pipeline();
            CommandHandler commandHandler = (CommandHandler)pipeline.get(CommandHandler.class);
            if (commandHandler != null && !commandHandler.isClosed()) {
                commandHandler.close();
            }
            if ((psCommandHandler = (PubSubCommandHandler)pipeline.get(PubSubCommandHandler.class)) == null || psCommandHandler.isClosed()) continue;
            psCommandHandler.close();
        }
        ChannelGroupFuture closeFuture = this.channels.close();
        Future groupCloseFuture = this.eventLoopGroup.shutdownGracefully(quietPeriod, timeout, timeUnit);
        try {
            closeFuture.get();
            groupCloseFuture.get();
        }
        catch (Exception e) {
            throw new RedisException(e);
        }
        this.timer.stop();
    }

    protected int getResourceCount() {
        return this.closeableResources.size();
    }

    protected int getChannelCount() {
        return this.channels.size();
    }

    protected static <K, V> Object syncHandler(RedisChannelHandler<K, V> connection, Class<?> ... interfaceClasses) {
        FutureSyncInvocationHandler<K, V> h = new FutureSyncInvocationHandler<K, V>(connection);
        return Proxy.newProxyInstance(AbstractRedisClient.class.getClassLoader(), interfaceClasses, h);
    }

    public void addListener(RedisConnectionStateListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"RedisConnectionStateListener must not be null");
        this.connectionEvents.addListener(listener);
    }

    public void removeListener(RedisConnectionStateListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"RedisConnectionStateListener must not be null");
        this.connectionEvents.removeListener(listener);
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)DEFAULT_EVENT_LOOP_THREADS);
        }
    }
}

