/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.ChannelGroupListener;
import com.lambdaworks.redis.CloseEvents;
import com.lambdaworks.redis.ConnectionEventTrigger;
import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.RedisAsyncConnectionImpl;
import com.lambdaworks.redis.RedisClusterConnection;
import com.lambdaworks.redis.RedisConnection;
import com.lambdaworks.redis.RedisConnectionException;
import com.lambdaworks.redis.RedisConnectionPool;
import com.lambdaworks.redis.RedisConnectionProvider;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisSentinelAsyncConnection;
import com.lambdaworks.redis.RedisSentinelAsyncConnectionImpl;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.protocol.ConnectionWatchdog;
import com.lambdaworks.redis.pubsub.PubSubCommandHandler;
import com.lambdaworks.redis.pubsub.RedisPubSubConnectionImpl;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.Timer;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RedisClient
extends AbstractRedisClient {
    private final RedisCodec<String, String> codec = new Utf8StringCodec();
    private final RedisURI redisURI;

    public RedisClient() {
        this.redisURI = null;
    }

    public RedisClient(String host) {
        this(host, 6379);
    }

    public RedisClient(String host, int port) {
        this(RedisURI.Builder.redis(host, port).build());
    }

    public RedisClient(RedisURI redisURI) {
        this.redisURI = redisURI;
        this.setDefaultTimeout(redisURI.getTimeout(), redisURI.getUnit());
    }

    public RedisConnectionPool<RedisConnection<String, String>> pool() {
        return this.pool(5, 20);
    }

    public RedisConnectionPool<RedisConnection<String, String>> pool(int maxIdle, int maxActive) {
        return this.pool(this.codec, maxIdle, maxActive);
    }

    public <K, V> RedisConnectionPool<RedisConnection<K, V>> pool(final RedisCodec<K, V> codec, int maxIdle, int maxActive) {
        this.checkForRedisURI();
        long maxWait = this.unit.convert(this.timeout, TimeUnit.MILLISECONDS);
        RedisConnectionPool<RedisConnection<K, V>> pool = new RedisConnectionPool<RedisConnection<K, V>>(new RedisConnectionProvider<RedisConnection<K, V>>(){

            @Override
            public RedisConnection<K, V> createConnection() {
                return RedisClient.this.connect(codec, false, RedisClient.this.redisURI);
            }

            @Override
            public Class<? extends RedisConnection<K, V>> getComponentType() {
                return RedisConnection.class;
            }
        }, maxActive, maxIdle, maxWait);
        pool.addListener(new CloseEvents.CloseListener(){

            @Override
            public void resourceClosed(Object resource) {
                RedisClient.this.closeableResources.remove(resource);
            }
        });
        this.closeableResources.add(pool);
        return pool;
    }

    private void checkForRedisURI() {
        Preconditions.checkState((this.redisURI != null ? 1 : 0) != 0, (Object)"RedisURI is not available. Use RedisClient(Host), RedisClient(Host, Port) or RedisClient(RedisURI) to construct your client.");
    }

    public RedisConnectionPool<RedisAsyncConnection<String, String>> asyncPool() {
        return this.asyncPool(5, 20);
    }

    public RedisConnectionPool<RedisAsyncConnection<String, String>> asyncPool(int maxIdle, int maxActive) {
        return this.asyncPool(this.codec, maxIdle, maxActive);
    }

    public <K, V> RedisConnectionPool<RedisAsyncConnection<K, V>> asyncPool(final RedisCodec<K, V> codec, int maxIdle, int maxActive) {
        this.checkForRedisURI();
        long maxWait = this.unit.convert(this.timeout, TimeUnit.MILLISECONDS);
        RedisConnectionPool<RedisAsyncConnection<K, V>> pool = new RedisConnectionPool<RedisAsyncConnection<K, V>>(new RedisConnectionProvider<RedisAsyncConnection<K, V>>(){

            @Override
            public RedisAsyncConnection<K, V> createConnection() {
                return RedisClient.this.connectAsyncImpl(codec, false, RedisClient.this.redisURI);
            }

            @Override
            public Class<? extends RedisAsyncConnection<K, V>> getComponentType() {
                return RedisAsyncConnection.class;
            }
        }, maxActive, maxIdle, maxWait);
        pool.addListener(new CloseEvents.CloseListener(){

            @Override
            public void resourceClosed(Object resource) {
                RedisClient.this.closeableResources.remove(resource);
            }
        });
        this.closeableResources.add(pool);
        return pool;
    }

    public RedisConnection<String, String> connect() {
        return this.connect(this.codec);
    }

    public <K, V> RedisConnection<K, V> connect(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        Preconditions.checkArgument((codec != null ? 1 : 0) != 0, (Object)"RedisCodec must not be null");
        return this.connect(codec, true, this.redisURI);
    }

    public RedisConnection<String, String> connect(RedisURI redisURI) {
        this.checkValidRedisURI(redisURI);
        return this.connect(this.codec, true, redisURI);
    }

    private void checkValidRedisURI(RedisURI redisURI) {
        Preconditions.checkArgument((redisURI != null && LettuceStrings.isNotEmpty(redisURI.getHost()) ? 1 : 0) != 0, (Object)"A valid RedisURI with a host is needed");
    }

    private <K, V> RedisConnection connect(RedisCodec<K, V> codec, boolean withReconnect, RedisURI redisURI) {
        return (RedisConnection)RedisClient.syncHandler(this.connectAsyncImpl(codec, withReconnect, redisURI), RedisConnection.class, RedisClusterConnection.class);
    }

    public RedisAsyncConnection<String, String> connectAsync() {
        return this.connectAsync(this.codec);
    }

    public <K, V> RedisAsyncConnection<K, V> connectAsync(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        Preconditions.checkArgument((codec != null ? 1 : 0) != 0, (Object)"RedisCodec must not be null");
        return this.connectAsyncImpl(codec, true, this.redisURI);
    }

    public RedisAsyncConnection<String, String> connectAsync(RedisURI redisURI) {
        this.checkValidRedisURI(redisURI);
        return this.connectAsyncImpl(this.codec, true, redisURI);
    }

    private <K, V> RedisAsyncConnectionImpl<K, V> connectAsyncImpl(RedisCodec<K, V> codec, boolean withReconnect, RedisURI redisURI) {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        CommandHandler handler = new CommandHandler(queue);
        RedisAsyncConnectionImpl connection = new RedisAsyncConnectionImpl(handler, codec, this.timeout, this.unit);
        this.connectAsyncImpl(handler, connection, withReconnect, redisURI);
        return connection;
    }

    private <K, V> void connectAsyncImpl(CommandHandler<K, V> handler, RedisAsyncConnectionImpl<K, V> connection, boolean withReconnect, RedisURI redisURI) {
        this.connectAsyncImpl(handler, connection, this.getSocketAddressSupplier(redisURI), withReconnect);
        if (redisURI.getPassword() != null && redisURI.getPassword().length != 0) {
            connection.auth(new String(redisURI.getPassword()));
        }
        if (redisURI.getDatabase() != 0) {
            connection.select(redisURI.getDatabase());
        }
    }

    public RedisPubSubConnectionImpl<String, String> connectPubSub() {
        return this.connectPubSub(this.codec);
    }

    public <K, V> RedisPubSubConnectionImpl<K, V> connectPubSub(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        Preconditions.checkArgument((codec != null ? 1 : 0) != 0, (Object)"RedisCodec must not be null");
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        PubSubCommandHandler handler = new PubSubCommandHandler(queue, codec);
        RedisPubSubConnectionImpl connection = new RedisPubSubConnectionImpl(handler, codec, this.timeout, this.unit);
        this.connectAsyncImpl(handler, connection, true, this.redisURI);
        return connection;
    }

    public RedisSentinelAsyncConnection<String, String> connectSentinelAsync() {
        return this.connectSentinelAsync(this.codec);
    }

    public <K, V> RedisSentinelAsyncConnection<K, V> connectSentinelAsync(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        Preconditions.checkArgument((codec != null ? 1 : 0) != 0, (Object)"RedisCodec must not be null");
        return this.connectSentinelAsyncImpl(codec, this.redisURI);
    }

    public RedisSentinelAsyncConnection<String, String> connectSentinelAsync(RedisURI redisURI) {
        return this.connectSentinelAsyncImpl(this.codec, redisURI);
    }

    private <K, V> RedisSentinelAsyncConnection<K, V> connectSentinelAsyncImpl(RedisCodec<K, V> codec, RedisURI redisURI) {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        final CommandHandler commandHandler = new CommandHandler(queue);
        final RedisSentinelAsyncConnectionImpl connection = new RedisSentinelAsyncConnectionImpl(commandHandler, codec, this.timeout, this.unit);
        logger.debug("Trying to get a Sentinel connection for one of: " + redisURI.getSentinels());
        Bootstrap sentinelBootstrap = (Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group(this.eventLoopGroup);
        final ConnectionWatchdog watchdog = new ConnectionWatchdog(sentinelBootstrap, (Timer)this.timer);
        watchdog.setReconnect(true);
        sentinelBootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{watchdog, new ChannelGroupListener(RedisClient.this.channels), watchdog, commandHandler, new ConnectionEventTrigger(RedisClient.this.connectionEvents, connection)});
            }
        });
        if (redisURI.getSentinels().isEmpty() && LettuceStrings.isNotEmpty(redisURI.getHost())) {
            sentinelBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)redisURI.getUnit().toMillis(redisURI.getTimeout())));
            ChannelFuture connect = sentinelBootstrap.connect(redisURI.getResolvedAddress());
            logger.debug("Connecting to Sentinel, address: " + redisURI.getResolvedAddress());
            try {
                connect.sync();
            }
            catch (InterruptedException e) {
                throw new RedisException(e.getMessage(), e);
            }
        }
        boolean connected = false;
        Exception causingException = null;
        for (RedisURI uri : redisURI.getSentinels()) {
            sentinelBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)uri.getUnit().toMillis(uri.getTimeout())));
            ChannelFuture connect = sentinelBootstrap.connect(uri.getResolvedAddress());
            logger.debug("Connecting to Sentinel, address: " + uri.getResolvedAddress());
            try {
                connect.sync();
                connected = true;
            }
            catch (Exception e) {
                logger.warn("Cannot connect sentinel at " + uri.getHost() + ":" + uri.getPort() + ": " + e.toString());
                if (causingException == null) {
                    causingException = e;
                }
                if (!(e instanceof ConnectException)) continue;
            }
        }
        if (!connected) {
            throw new RedisException("Cannot connect to a sentinel: " + redisURI.getSentinels(), causingException);
        }
        connection.registerCloseables(this.closeableResources, connection);
        return connection;
    }

    private Supplier<SocketAddress> getSocketAddressSupplier(final RedisURI redisURI) {
        return new Supplier<SocketAddress>(){

            public SocketAddress get() {
                try {
                    return RedisClient.this.getSocketAddress(redisURI);
                }
                catch (InterruptedException e) {
                    throw new RedisException(e);
                }
                catch (TimeoutException e) {
                    throw new RedisException(e);
                }
                catch (ExecutionException e) {
                    throw new RedisException(e);
                }
            }
        };
    }

    protected SocketAddress getSocketAddress(RedisURI redisURI) throws InterruptedException, TimeoutException, ExecutionException {
        SocketAddress redisAddress;
        if (redisURI.getSentinelMasterId() != null && !redisURI.getSentinels().isEmpty()) {
            logger.debug("Connecting to Redis using Sentinels " + redisURI.getSentinels() + ", MasterId " + redisURI.getSentinelMasterId());
            redisAddress = this.lookupRedis(redisURI.getSentinelMasterId());
            if (redisAddress == null) {
                throw new RedisConnectionException("Cannot provide redisAddress using sentinel for masterId " + redisURI.getSentinelMasterId());
            }
        } else {
            redisAddress = redisURI.getResolvedAddress();
        }
        return redisAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketAddress lookupRedis(String sentinelMasterId) throws InterruptedException, TimeoutException, ExecutionException {
        RedisSentinelAsyncConnection<String, String> connection = this.connectSentinelAsync();
        try {
            SocketAddress socketAddress = connection.getMasterAddrByName(sentinelMasterId).get(this.timeout, this.unit);
            return socketAddress;
        }
        finally {
            connection.close();
        }
    }
}

