/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class RedisURI
implements Serializable {
    public static final int DEFAULT_SENTINEL_PORT = 26379;
    public static final int DEFAULT_REDIS_PORT = 6379;
    private String host;
    private String sentinelMasterId;
    private int port;
    private int database;
    private char[] password;
    private long timeout = 60L;
    private TimeUnit unit = TimeUnit.SECONDS;
    private final List<RedisURI> sentinels = new ArrayList<RedisURI>();
    private transient SocketAddress resolvedAddress;

    public RedisURI() {
    }

    public RedisURI(String host, int port, long timeout, TimeUnit unit) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.unit = unit;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getSentinelMasterId() {
        return this.sentinelMasterId;
    }

    public void setSentinelMasterId(String sentinelMasterId) {
        this.sentinelMasterId = sentinelMasterId;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password.toCharArray();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public List<RedisURI> getSentinels() {
        return this.sentinels;
    }

    public SocketAddress getResolvedAddress() {
        if (this.resolvedAddress == null) {
            this.resolvedAddress = new InetSocketAddress(this.host, this.port);
        }
        return this.resolvedAddress;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [host='").append(this.host).append('\'');
        sb.append(", port=").append(this.port);
        sb.append(']');
        return sb.toString();
    }

    public static class Builder {
        private final RedisURI redisURI = new RedisURI();

        public static Builder redis(String host) {
            return Builder.redis(host, 6379);
        }

        public static Builder redis(String host, int port) {
            Preconditions.checkNotNull((Object)host, (Object)"Host must not be null");
            Builder builder = new Builder();
            builder.redisURI.setHost(host);
            builder.redisURI.setPort(port);
            return builder;
        }

        public static Builder sentinel(String host) {
            return Builder.sentinel(host, 26379, null);
        }

        public static Builder sentinel(String host, int port) {
            return Builder.sentinel(host, port, null);
        }

        public static Builder sentinel(String host, String masterId) {
            return Builder.sentinel(host, 26379, masterId);
        }

        public static Builder sentinel(String host, int port, String masterId) {
            Preconditions.checkNotNull((Object)host, (Object)"Host must not be null");
            Builder builder = new Builder();
            builder.redisURI.setSentinelMasterId(masterId);
            builder.redisURI.sentinels.add(new RedisURI(host, port, 1L, TimeUnit.SECONDS));
            return builder;
        }

        public Builder withSentinel(String host) {
            return this.withSentinel(host, 26379);
        }

        public Builder withSentinel(String host, int port) {
            Preconditions.checkState((this.redisURI.host == null ? 1 : 0) != 0, (Object)"Cannot use with Redis mode.");
            Preconditions.checkNotNull((Object)host, (Object)"Host must not be null");
            this.redisURI.sentinels.add(new RedisURI(host, port, 1L, TimeUnit.SECONDS));
            return this;
        }

        public Builder withPort(int port) {
            Preconditions.checkState((this.redisURI.host != null ? 1 : 0) != 0, (Object)"Host is null. Cannot use in Sentinel mode.");
            this.redisURI.setPort(port);
            return this;
        }

        public Builder withDatabase(int database) {
            this.redisURI.setDatabase(database);
            return this;
        }

        public Builder withPassword(String password) {
            Preconditions.checkNotNull((Object)password, (Object)"Password must not be null");
            this.redisURI.setPassword(password);
            return this;
        }

        public Builder withTimeout(long timeout, TimeUnit unit) {
            Preconditions.checkNotNull((Object)((Object)unit), (Object)"TimeUnit must not be null");
            Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"Timeout must be greater or equal 0");
            this.redisURI.setTimeout(timeout);
            this.redisURI.setUnit(unit);
            return this;
        }

        public RedisURI build() {
            return this.redisURI;
        }
    }
}

