/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

public class ScoredValue<V> {
    public final double score;
    public final V value;

    public ScoredValue(double score, V value) {
        this.score = score;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScoredValue that = (ScoredValue)o;
        return Double.compare(that.score, this.score) == 0 && this.value.equals(that.value);
    }

    public int hashCode() {
        long temp = this.score != 0.0 ? Double.doubleToLongBits(this.score) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        return 31 * result + (this.value != null ? this.value.hashCode() : 0);
    }

    public String toString() {
        return String.format("(%f, %s)", this.score, this.value);
    }
}

