/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.net.HostAndPort;
import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.RedisAsyncConnectionImpl;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.cluster.ClusterCommand;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.SlotHash;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.RedisCommand;
import java.util.List;

class ClusterDistributionChannelWriter<K, V>
implements RedisChannelWriter<K, V> {
    private RedisChannelWriter<K, V> defaultWriter;
    private ClusterConnectionProvider clusterConnectionProvider;
    private boolean closed = false;
    private int executionLimit = 5;

    public ClusterDistributionChannelWriter(RedisChannelWriter<K, V> defaultWriter, ClusterConnectionProvider clusterConnectionProvider) {
        this.defaultWriter = defaultWriter;
        this.clusterConnectionProvider = clusterConnectionProvider;
    }

    @Override
    public <T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> command) {
        ClusterCommand clusterCommand;
        Command singleCommand;
        RedisCommand<K, V, T> commandToSend = command;
        CommandArgs<K, V> args = command.getArgs();
        if (command instanceof Command && !(singleCommand = (Command)command).isMulti()) {
            commandToSend = new ClusterCommand(singleCommand, this, this.executionLimit);
        }
        RedisChannelWriter<K, V> channelWriter = null;
        if (commandToSend instanceof ClusterCommand && !(clusterCommand = (ClusterCommand)commandToSend).isDone() && clusterCommand.isMoved()) {
            HostAndPort moveTarget = this.getMoveTarget(clusterCommand.getError());
            RedisAsyncConnectionImpl connection = this.clusterConnectionProvider.getConnection(ClusterConnectionProvider.Intent.WRITE, moveTarget.getHostText(), moveTarget.getPort());
            channelWriter = connection.getChannelWriter();
        }
        if (channelWriter == null && args != null && !args.getKeys().isEmpty()) {
            int hash = this.getHash(args.getEncodedKey(0));
            RedisAsyncConnectionImpl connection = this.clusterConnectionProvider.getConnection(ClusterConnectionProvider.Intent.WRITE, hash);
            channelWriter = connection.getChannelWriter();
        }
        if (channelWriter instanceof ClusterDistributionChannelWriter) {
            ClusterDistributionChannelWriter writer = (ClusterDistributionChannelWriter)channelWriter;
            channelWriter = writer.defaultWriter;
        }
        commandToSend.getOutput().setError((String)null);
        if (channelWriter != null && channelWriter != this && channelWriter != this.defaultWriter) {
            return channelWriter.write(commandToSend);
        }
        return this.defaultWriter.write(commandToSend);
    }

    private HostAndPort getMoveTarget(String errorMessage) {
        Preconditions.checkArgument((boolean)LettuceStrings.isNotEmpty(errorMessage), (Object)"errorMessage must not be empty");
        Preconditions.checkArgument((boolean)errorMessage.startsWith(CommandKeyword.MOVED.name()), (Object)("errorMessage must start with " + (Object)((Object)CommandKeyword.MOVED)));
        List movedMessageParts = Splitter.on((char)' ').splitToList((CharSequence)errorMessage);
        Preconditions.checkArgument((movedMessageParts.size() >= 3 ? 1 : 0) != 0, (Object)("errorMessage must consist of 3 tokens (" + movedMessageParts + ")"));
        return HostAndPort.fromString((String)((String)movedMessageParts.get(2)));
    }

    protected int getHash(byte[] encodedKey) {
        return SlotHash.getSlot(encodedKey);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.defaultWriter != null) {
            this.defaultWriter.close();
            this.defaultWriter = null;
        }
        if (this.clusterConnectionProvider != null) {
            this.clusterConnectionProvider.close();
            this.clusterConnectionProvider = null;
        }
    }

    @Override
    public void setRedisChannelHandler(RedisChannelHandler<K, V> redisChannelHandler) {
        this.defaultWriter.setRedisChannelHandler(redisChannelHandler);
    }

    public ClusterConnectionProvider getClusterConnectionProvider() {
        return this.clusterConnectionProvider;
    }
}

