/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.RedisAsyncConnectionImpl;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.RedisClusterClient;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.codec.RedisCodec;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;

class PooledClusterConnectionProvider<K, V>
implements ClusterConnectionProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PooledClusterConnectionProvider.class);
    private KeyedObjectPool<PoolKey, RedisAsyncConnection<K, V>> partitionPool;
    private final Partitions partitions;

    public PooledClusterConnectionProvider(RedisClusterClient redisClusterClient, Partitions partitions, RedisCodec<K, V> redisCodec) {
        this.partitions = partitions;
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setMaxIdlePerKey(1);
        config.setMaxTotalPerKey(1);
        config.setTestOnBorrow(true);
        this.partitionPool = new GenericKeyedObjectPool(new KeyedConnectionFactory(redisClusterClient, redisCodec), config);
    }

    @Override
    public <K, V> RedisAsyncConnectionImpl<K, V> getConnection(ClusterConnectionProvider.Intent intent, int slot) {
        logger.debug("getConnection(" + (Object)((Object)intent) + ", " + slot + ")");
        RedisClusterNode partition = this.partitions.getPartitionBySlot(slot);
        if (partition == null) {
            throw new RedisException("Cannot determine a partition for slot " + slot + " (Partitions: " + this.partitions + ")");
        }
        try {
            PoolKey key = new PoolKey(intent, partition.getUri());
            RedisAsyncConnection connection = (RedisAsyncConnection)this.partitionPool.borrowObject((Object)key);
            this.partitionPool.returnObject((Object)key, (Object)connection);
            return (RedisAsyncConnectionImpl)connection;
        }
        catch (Exception e) {
            throw new RedisException(e);
        }
    }

    @Override
    public <K, V> RedisAsyncConnectionImpl<K, V> getConnection(ClusterConnectionProvider.Intent intent, String host, int port) {
        try {
            logger.debug("getConnection(" + (Object)((Object)intent) + ", " + host + ", " + port + ")");
            PoolKey key = new PoolKey(intent, host, port);
            RedisAsyncConnection connection = (RedisAsyncConnection)this.partitionPool.borrowObject((Object)key);
            this.partitionPool.returnObject((Object)key, (Object)connection);
            return (RedisAsyncConnectionImpl)connection;
        }
        catch (Exception e) {
            throw new RedisException(e);
        }
    }

    @Override
    public void close() {
        if (this.partitionPool != null) {
            this.partitionPool.close();
        }
        this.partitionPool = null;
    }

    private static class PoolKey {
        private final ClusterConnectionProvider.Intent intent;
        private SocketAddress socketAddress;
        private final String host;
        private final int port;

        private PoolKey(ClusterConnectionProvider.Intent intent, RedisURI uri) {
            this.intent = intent;
            this.host = uri.getHost();
            this.port = uri.getPort();
            this.socketAddress = uri.getResolvedAddress();
        }

        private PoolKey(ClusterConnectionProvider.Intent intent, String host, int port) {
            this.intent = intent;
            this.host = host;
            this.port = port;
        }

        public ClusterConnectionProvider.Intent getIntent() {
            return this.intent;
        }

        public SocketAddress getSocketAddress() {
            if (this.socketAddress == null && LettuceStrings.isNotEmpty(this.host)) {
                this.socketAddress = new InetSocketAddress(this.host, this.port);
            }
            return this.socketAddress;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PoolKey)) {
                return false;
            }
            PoolKey poolKey = (PoolKey)o;
            if (this.port != poolKey.port) {
                return false;
            }
            if (this.host != null ? !this.host.equals(poolKey.host) : poolKey.host != null) {
                return false;
            }
            return this.intent == poolKey.intent;
        }

        public int hashCode() {
            int result = this.intent != null ? this.intent.hashCode() : 0;
            result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
            result = 31 * result + this.port;
            return result;
        }
    }

    private static class KeyedConnectionFactory<K, V>
    extends BaseKeyedPooledObjectFactory<PoolKey, RedisAsyncConnection<K, V>> {
        private final RedisClusterClient redisClusterClient;
        private final RedisCodec<K, V> redisCodec;

        private KeyedConnectionFactory(RedisClusterClient redisClusterClient, RedisCodec<K, V> redisCodec) {
            this.redisClusterClient = redisClusterClient;
            this.redisCodec = redisCodec;
        }

        public RedisAsyncConnection<K, V> create(PoolKey key) throws Exception {
            logger.debug("createConnection(" + (Object)((Object)key.getIntent()) + ", " + key.getSocketAddress() + ")");
            return this.redisClusterClient.connectAsyncImpl(this.redisCodec, key.getSocketAddress());
        }

        public boolean validateObject(PoolKey key, PooledObject<RedisAsyncConnection<K, V>> p) {
            return ((RedisAsyncConnection)p.getObject()).isOpen();
        }

        public void destroyObject(PoolKey key, PooledObject<RedisAsyncConnection<K, V>> p) throws Exception {
            ((RedisAsyncConnection)p.getObject()).close();
        }

        public PooledObject<RedisAsyncConnection<K, V>> wrap(RedisAsyncConnection<K, V> value) {
            return new DefaultPooledObject(value);
        }
    }
}

