/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.google.common.primitives.Chars;
import com.lambdaworks.codec.CRC16;

public class SlotHash {
    public static final byte SUBKEY_START = Chars.toByteArray((char)'{')[1];
    public static final byte SUBKEY_END = Chars.toByteArray((char)'}')[1];

    private SlotHash() {
    }

    public static final int getSlot(String key) {
        return SlotHash.getSlot(key.getBytes());
    }

    public static final int getSlot(byte[] key) {
        int end;
        byte[] finalKey = key;
        int start = SlotHash.indexOf(key, SUBKEY_START);
        if (start != -1 && (end = SlotHash.indexOf(key, start + 1, SUBKEY_END)) != -1 && end != start + 1) {
            finalKey = new byte[end - (start + 1)];
            System.arraycopy(key, start + 1, finalKey, 0, finalKey.length);
        }
        return CRC16.crc16(finalKey) % 16384;
    }

    private static int indexOf(byte[] haystack, byte needle) {
        return SlotHash.indexOf(haystack, 0, needle);
    }

    private static int indexOf(byte[] haystack, int start, byte needle) {
        for (int i = start; i < haystack.length; ++i) {
            if (haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }
}

