/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.models.partitions;

import com.google.common.collect.Lists;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.util.Iterator;
import java.util.List;

public class Partitions
implements Iterable<RedisClusterNode> {
    private List<RedisClusterNode> partitions = Lists.newArrayList();

    public RedisClusterNode getPartitionBySlot(int slot) {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.getSlots().contains(slot)) continue;
            return partition;
        }
        return null;
    }

    @Override
    public Iterator<RedisClusterNode> iterator() {
        return Lists.newArrayList(this.partitions).iterator();
    }

    public List<RedisClusterNode> getPartitions() {
        return this.partitions;
    }

    public void addPartition(RedisClusterNode partition) {
        this.partitions.add(partition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" ").append(this.partitions);
        return sb.toString();
    }
}

