/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.models.slots;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class ClusterSlotRange
implements Serializable {
    private int from;
    private int to;
    private HostAndPort master;
    private List<HostAndPort> slaves = Collections.emptyList();

    public ClusterSlotRange() {
    }

    public ClusterSlotRange(int from, int to, HostAndPort master, List<HostAndPort> slaves) {
        Preconditions.checkArgument((master != null ? 1 : 0) != 0, (Object)"master must not be null");
        Preconditions.checkArgument((slaves != null ? 1 : 0) != 0, (Object)"slaves must not be null");
        this.from = from;
        this.to = to;
        this.master = master;
        this.slaves = slaves;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public HostAndPort getMaster() {
        return this.master;
    }

    public List<HostAndPort> getSlaves() {
        return this.slaves;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public void setTo(int to) {
        this.to = to;
    }

    public void setMaster(HostAndPort master) {
        Preconditions.checkArgument((master != null ? 1 : 0) != 0, (Object)"master must not be null");
        this.master = master;
    }

    public void setSlaves(List<HostAndPort> slaves) {
        Preconditions.checkArgument((slaves != null ? 1 : 0) != 0, (Object)"slaves must not be null");
        this.slaves = slaves;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [from=").append(this.from);
        sb.append(", to=").append(this.to);
        sb.append(", master=").append(this.master);
        sb.append(", slaves=").append(this.slaves);
        sb.append(']');
        return sb.toString();
    }
}

