/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.models.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.lambdaworks.redis.models.command.CommandDetail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandDetailParser {
    public static final int COMMAND_INFO_SIZE = 6;
    protected static final Map<String, CommandDetail.Flag> FLAG_MAPPING = new HashMap<String, CommandDetail.Flag>(){
        {
            this.put("admin", CommandDetail.Flag.ADMIN);
            this.put("asking", CommandDetail.Flag.ASKING);
            this.put("denyoom", CommandDetail.Flag.DENYOOM);
            this.put("fast", CommandDetail.Flag.FAST);
            this.put("loading", CommandDetail.Flag.LOADING);
            this.put("noscript", CommandDetail.Flag.NOSCRIPT);
            this.put("movablekeys", CommandDetail.Flag.MOVABLEKEYS);
            this.put("pubsub", CommandDetail.Flag.PUBSUB);
            this.put("random", CommandDetail.Flag.RANDOM);
            this.put("readonly", CommandDetail.Flag.READONLY);
            this.put("skip_monitor", CommandDetail.Flag.SKIP_MONITOR);
            this.put("sort_for_script", CommandDetail.Flag.SORT_FOR_SCRIPT);
            this.put("stale", CommandDetail.Flag.STALE);
            this.put("write", CommandDetail.Flag.WRITE);
        }
    };

    private CommandDetailParser() {
    }

    public static List<CommandDetail> parse(List<?> commandOutput) {
        Preconditions.checkArgument((commandOutput != null ? 1 : 0) != 0, (Object)"CommandOutput must not be null");
        ArrayList result = Lists.newArrayList();
        for (Object o : commandOutput) {
            Collection collection;
            if (!(o instanceof Collection) || (collection = (Collection)o).size() != 6) continue;
            CommandDetail commandDetail = CommandDetailParser.parseCommandDetail(collection);
            result.add(commandDetail);
        }
        return Collections.unmodifiableList(result);
    }

    private static CommandDetail parseCommandDetail(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        String name = (String)iterator.next();
        int arity = Ints.checkedCast((long)CommandDetailParser.getLongFromIterator(iterator, 0L));
        Object flags = iterator.next();
        int firstKey = Ints.checkedCast((long)CommandDetailParser.getLongFromIterator(iterator, 0L));
        int lastKey = Ints.checkedCast((long)CommandDetailParser.getLongFromIterator(iterator, 0L));
        int keyStepCount = Ints.checkedCast((long)CommandDetailParser.getLongFromIterator(iterator, 0L));
        Set<CommandDetail.Flag> parsedFlags = CommandDetailParser.parseFlags(flags);
        return new CommandDetail(name, arity, parsedFlags, firstKey, lastKey, keyStepCount);
    }

    private static Set<CommandDetail.Flag> parseFlags(Object flags) {
        HashSet result = Sets.newHashSet();
        if (flags instanceof Collection) {
            Collection collection = (Collection)flags;
            for (Object o : collection) {
                CommandDetail.Flag flag = FLAG_MAPPING.get(o);
                if (flag == null) continue;
                result.add(flag);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private static long getLongFromIterator(Iterator<?> iterator, long defaultValue) {
        if (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
        }
        return defaultValue;
    }
}

