/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.models.role;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import com.lambdaworks.redis.models.role.RedisInstance;
import com.lambdaworks.redis.models.role.RedisMasterInstance;
import com.lambdaworks.redis.models.role.RedisSentinelInstance;
import com.lambdaworks.redis.models.role.RedisSlaveInstance;
import com.lambdaworks.redis.models.role.ReplicationPartner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RoleParser {
    protected static final Map<String, RedisInstance.Role> ROLE_MAPPING = new HashMap<String, RedisInstance.Role>(){
        {
            this.put("master", RedisInstance.Role.MASTER);
            this.put("slave", RedisInstance.Role.SLAVE);
            this.put("sentinel", RedisInstance.Role.SENTINEL);
        }
    };
    protected static final Map<String, RedisSlaveInstance.State> SLAVE_STATE_MAPPING = new HashMap<String, RedisSlaveInstance.State>(){
        {
            this.put("connect", RedisSlaveInstance.State.CONNECT);
            this.put("connected", RedisSlaveInstance.State.CONNECTED);
            this.put("connecting", RedisSlaveInstance.State.CONNECTING);
            this.put("sync", RedisSlaveInstance.State.SYNC);
        }
    };

    private RoleParser() {
    }

    public static RedisInstance parse(List<?> roleOutput) {
        Preconditions.checkArgument((roleOutput != null && !roleOutput.isEmpty() ? 1 : 0) != 0, (Object)"Empty role output");
        Preconditions.checkArgument((roleOutput.get(0) instanceof String && ROLE_MAPPING.containsKey(roleOutput.get(0)) ? 1 : 0) != 0, (Object)("First role element must be a string (any of " + ROLE_MAPPING.keySet() + ")"));
        RedisInstance.Role role = ROLE_MAPPING.get(roleOutput.get(0));
        switch (role) {
            case MASTER: {
                return RoleParser.parseMaster(roleOutput);
            }
            case SLAVE: {
                return RoleParser.parseSlave(roleOutput);
            }
            case SENTINEL: {
                return RoleParser.parseSentinel(roleOutput);
            }
        }
        return null;
    }

    private static RedisInstance parseMaster(List<?> roleOutput) {
        long replicationOffset = RoleParser.getMasterReplicationOffset(roleOutput);
        List<ReplicationPartner> slaves = RoleParser.getMasterSlaveReplicationPartners(roleOutput);
        RedisMasterInstance redisMasterInstanceRole = new RedisMasterInstance(replicationOffset, Collections.unmodifiableList(slaves));
        return redisMasterInstanceRole;
    }

    private static RedisInstance parseSlave(List<?> roleOutput) {
        Iterator<?> iterator = roleOutput.iterator();
        iterator.next();
        String ip = RoleParser.getStringFromIterator(iterator, "");
        long port = RoleParser.getLongFromIterator(iterator, 0L);
        String stateString = RoleParser.getStringFromIterator(iterator, null);
        long replicationOffset = RoleParser.getLongFromIterator(iterator, 0L);
        ReplicationPartner master = new ReplicationPartner(HostAndPort.fromParts((String)ip, (int)Ints.checkedCast((long)port)), replicationOffset);
        RedisSlaveInstance.State state = SLAVE_STATE_MAPPING.get(stateString);
        RedisSlaveInstance redisSlaveInstanceRole = new RedisSlaveInstance(master, state);
        return redisSlaveInstanceRole;
    }

    private static RedisInstance parseSentinel(List<?> roleOutput) {
        Iterator<?> iterator = roleOutput.iterator();
        iterator.next();
        List<String> monitoredMasters = RoleParser.getMonitoredMasters(iterator);
        RedisSentinelInstance result = new RedisSentinelInstance(Collections.unmodifiableList(monitoredMasters));
        return result;
    }

    private static List<String> getMonitoredMasters(Iterator<?> iterator) {
        ArrayList monitoredMasters = Lists.newArrayList();
        if (!iterator.hasNext()) {
            return monitoredMasters;
        }
        Object masters = iterator.next();
        if (!(masters instanceof Collection)) {
            return monitoredMasters;
        }
        for (Object monitoredMaster : (Collection)masters) {
            if (!(monitoredMaster instanceof String)) continue;
            monitoredMasters.add((String)monitoredMaster);
        }
        return monitoredMasters;
    }

    private static List<ReplicationPartner> getMasterSlaveReplicationPartners(List<?> roleOutput) {
        ArrayList slaves = Lists.newArrayList();
        if (roleOutput.size() > 2 && roleOutput.get(2) instanceof Collection) {
            Collection slavesOutput = (Collection)roleOutput.get(2);
            for (Object slaveOutput : slavesOutput) {
                if (!(slaveOutput instanceof Collection)) continue;
                ReplicationPartner replicationPartner = RoleParser.getMasterSlaveReplicationPartner((Collection)slaveOutput);
                slaves.add(replicationPartner);
            }
        }
        return slaves;
    }

    private static ReplicationPartner getMasterSlaveReplicationPartner(Collection<?> slaveOutput) {
        Iterator<?> iterator = slaveOutput.iterator();
        String ip = RoleParser.getStringFromIterator(iterator, "");
        long port = RoleParser.getLongFromIterator(iterator, 0L);
        long replicationOffset = RoleParser.getLongFromIterator(iterator, 0L);
        return new ReplicationPartner(HostAndPort.fromParts((String)ip, (int)Ints.checkedCast((long)port)), replicationOffset);
    }

    private static long getLongFromIterator(Iterator<?> iterator, long defaultValue) {
        if (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
        }
        return defaultValue;
    }

    private static String getStringFromIterator(Iterator<?> iterator, String defaultValue) {
        Object object;
        if (iterator.hasNext() && (object = iterator.next()) instanceof String) {
            return (String)object;
        }
        return defaultValue;
    }

    private static long getMasterReplicationOffset(List<?> roleOutput) {
        long replicationOffset = 0L;
        if (roleOutput.size() > 1 && roleOutput.get(1) instanceof Number) {
            Number number = (Number)roleOutput.get(1);
            replicationOffset = number.longValue();
        }
        return replicationOffset;
    }
}

