/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.protocol.LettuceCharsets;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CommandArgs<K, V> {
    private static final byte[] CRLF = "\r\n".getBytes(LettuceCharsets.ASCII);
    private final RedisCodec<K, V> codec;
    private ByteBuffer buffer;
    private int count;
    private final List<K> keys = new ArrayList<K>();
    private final List<CommandKeyword> keywords = new ArrayList<CommandKeyword>();

    public CommandArgs(RedisCodec<K, V> codec) {
        this.codec = codec;
        this.buffer = ByteBuffer.allocate(32);
    }

    public ByteBuffer buffer() {
        this.buffer.flip();
        return this.buffer;
    }

    public int count() {
        return this.count;
    }

    public CommandArgs<K, V> addKey(K key) {
        this.keys.add(key);
        return this.write(this.codec.encodeKey(key));
    }

    public CommandArgs<K, V> addKeys(K ... keys) {
        for (K key : keys) {
            this.addKey(key);
        }
        return this;
    }

    public CommandArgs<K, V> addValue(V value) {
        return this.write(this.codec.encodeValue(value));
    }

    public CommandArgs<K, V> addValues(V ... values) {
        for (V value : values) {
            this.addValue(value);
        }
        return this;
    }

    public CommandArgs<K, V> add(Map<K, V> map) {
        if (map.size() > 2) {
            this.realloc(this.buffer.capacity() + 16 * map.size());
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.write(this.codec.encodeKey(entry.getKey()));
            this.write(this.codec.encodeValue(entry.getValue()));
        }
        return this;
    }

    public CommandArgs<K, V> add(String s) {
        return this.write(s);
    }

    public CommandArgs<K, V> add(long n) {
        return this.write(Long.toString(n));
    }

    public CommandArgs<K, V> add(double n) {
        return this.write(Double.toString(n));
    }

    public CommandArgs<K, V> add(byte[] value) {
        return this.write(value);
    }

    public CommandArgs<K, V> add(CommandKeyword keyword) {
        this.keywords.add(keyword);
        return this.write(keyword.bytes);
    }

    public CommandArgs<K, V> add(CommandType type) {
        return this.write(type.bytes);
    }

    private CommandArgs<K, V> write(byte[] arg) {
        this.buffer.mark();
        if (this.buffer.remaining() < arg.length) {
            int estimate = this.buffer.remaining() + arg.length + 10;
            this.realloc(Math.max(this.buffer.capacity() * 2, estimate));
        }
        while (true) {
            try {
                this.buffer.put((byte)36);
                this.write(arg.length);
                this.buffer.put(CRLF);
                this.buffer.put(arg);
                this.buffer.put(CRLF);
            }
            catch (BufferOverflowException e) {
                this.buffer.reset();
                this.realloc(this.buffer.capacity() * 2);
                continue;
            }
            break;
        }
        ++this.count;
        return this;
    }

    private CommandArgs<K, V> write(String arg) {
        int length = arg.length();
        this.buffer.mark();
        if (this.buffer.remaining() < length) {
            int estimate = this.buffer.remaining() + length + 10;
            this.realloc(Math.max(this.buffer.capacity() * 2, estimate));
        }
        while (true) {
            try {
                this.buffer.put((byte)36);
                this.write(length);
                this.buffer.put(CRLF);
                for (int i = 0; i < length; ++i) {
                    this.buffer.put((byte)arg.charAt(i));
                }
                this.buffer.put(CRLF);
            }
            catch (BufferOverflowException e) {
                this.buffer.reset();
                this.realloc(this.buffer.capacity() * 2);
                continue;
            }
            break;
        }
        ++this.count;
        return this;
    }

    private void write(long value) {
        if (value < 10L) {
            this.buffer.put((byte)(48L + value));
            return;
        }
        StringBuilder sb = new StringBuilder(8);
        while (value > 0L) {
            long digit = value % 10L;
            sb.append((char)(48L + digit));
            value /= 10L;
        }
        for (int i = sb.length() - 1; i >= 0; --i) {
            this.buffer.put((byte)sb.charAt(i));
        }
    }

    private void realloc(int size) {
        ByteBuffer newBuffer = ByteBuffer.allocate(size);
        this.buffer.flip();
        newBuffer.put(this.buffer);
        newBuffer.mark();
        this.buffer = newBuffer;
    }

    public List<K> getKeys() {
        return this.keys;
    }

    public byte[] getEncodedKey(int index) {
        return this.codec.encodeKey(this.keys.get(index));
    }

    public List<CommandKeyword> getKeywords() {
        return this.keywords;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [keys=").append(this.keys);
        sb.append(", keywords=").append(this.keywords);
        sb.append(", buffer=").append(new String(this.buffer.array()));
        sb.append(']');
        return sb.toString();
    }
}

