/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.google.common.base.Supplier;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;

@ChannelHandler.Sharable
public class ConnectionWatchdog
extends ChannelInboundHandlerAdapter
implements TimerTask {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ConnectionWatchdog.class);
    public static final long LOGGING_QUIET_TIME_MS = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
    public static final int RETRY_TIMEOUT_MAX = 14;
    private Bootstrap bootstrap;
    private Channel channel;
    private Timer timer;
    private boolean reconnect;
    private int attempts;
    private SocketAddress remoteAddress;
    private Supplier<SocketAddress> socketAddressSupplier;
    private long lastReconnectionLogging = -1L;

    public ConnectionWatchdog(Bootstrap bootstrap, Timer timer) {
        this(bootstrap, timer, null);
    }

    public ConnectionWatchdog(Bootstrap bootstrap, Timer timer, Supplier<SocketAddress> socketAddressSupplier) {
        this.bootstrap = bootstrap;
        this.timer = timer;
        this.socketAddressSupplier = socketAddressSupplier;
    }

    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channel = ctx.channel();
        this.attempts = 0;
        this.remoteAddress = this.channel.remoteAddress();
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.channel = null;
        if (this.reconnect) {
            this.scheduleReconnect();
        }
        super.channelInactive(ctx);
    }

    private void scheduleReconnect() {
        if (this.channel == null || !this.channel.isActive()) {
            if (this.attempts < 14) {
                ++this.attempts;
            }
            int timeout = 2 << this.attempts;
            this.timer.newTimeout((TimerTask)this, (long)timeout, TimeUnit.MILLISECONDS);
        }
    }

    public void run(Timeout timeout) throws Exception {
        boolean shouldLog = this.shouldLog();
        InternalLogLevel infoLevel = InternalLogLevel.INFO;
        InternalLogLevel warnLevel = InternalLogLevel.WARN;
        if (shouldLog) {
            this.lastReconnectionLogging = System.currentTimeMillis();
        } else {
            warnLevel = InternalLogLevel.DEBUG;
            infoLevel = InternalLogLevel.DEBUG;
        }
        try {
            logger.log(infoLevel, "Reconnecting, last destination was " + this.remoteAddress);
            if (this.socketAddressSupplier != null) {
                try {
                    this.remoteAddress = (SocketAddress)this.socketAddressSupplier.get();
                }
                catch (RuntimeException e) {
                    logger.log(warnLevel, "Cannot retrieve the current address from socketAddressSupplier: " + e.toString());
                }
            }
            this.bootstrap.connect(this.remoteAddress).sync().await();
            logger.log(infoLevel, "Reconnected to " + this.remoteAddress);
        }
        catch (Exception e) {
            logger.log(warnLevel, "Cannot connect: " + e.toString());
            this.scheduleReconnect();
        }
    }

    private boolean shouldLog() {
        long quietUntil = this.lastReconnectionLogging + LOGGING_QUIET_TIME_MS;
        return quietUntil <= System.currentTimeMillis();
    }
}

