/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.pubsub;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.protocol.CommandOutput;
import com.lambdaworks.redis.protocol.RedisCommand;
import com.lambdaworks.redis.pubsub.PubSubOutput;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.BlockingQueue;

public class PubSubCommandHandler<K, V>
extends CommandHandler<K, V> {
    private RedisCodec<K, V> codec;
    private PubSubOutput<K, V> output;

    public PubSubCommandHandler(BlockingQueue<RedisCommand<K, V, ?>> queue, RedisCodec<K, V> codec) {
        super(queue);
        this.codec = codec;
        this.output = new PubSubOutput<K, V>(codec);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer) throws InterruptedException {
        while (this.output.type() == null && !this.queue.isEmpty()) {
            CommandOutput output = ((RedisCommand)this.queue.peek()).getOutput();
            if (!this.rsm.decode(buffer, output)) {
                return;
            }
            ((RedisCommand)this.queue.take()).complete();
            if (!(output instanceof PubSubOutput)) continue;
            ctx.fireChannelRead(output);
        }
        while (this.rsm.decode(buffer, this.output)) {
            ctx.fireChannelRead(this.output);
            this.output = new PubSubOutput<K, V>(this.codec);
        }
    }
}

