/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.pubsub;

import com.lambdaworks.redis.RedisAsyncConnectionImpl;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.pubsub.PubSubOutput;
import com.lambdaworks.redis.pubsub.RedisPubSubConnection;
import com.lambdaworks.redis.pubsub.RedisPubSubListener;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class RedisPubSubConnectionImpl<K, V>
extends RedisAsyncConnectionImpl<K, V>
implements RedisPubSubConnection<K, V> {
    private final List<RedisPubSubListener<K, V>> listeners = new CopyOnWriteArrayList<RedisPubSubListener<K, V>>();
    private final Set<K> channels = new HashSet<K>();
    private final Set<K> patterns = new HashSet<K>();

    public RedisPubSubConnectionImpl(RedisChannelWriter<K, V> writer, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        super(writer, codec, timeout, unit);
    }

    @Override
    public void addListener(RedisPubSubListener<K, V> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(RedisPubSubListener<K, V> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void psubscribe(K ... patterns) {
        this.dispatch(CommandType.PSUBSCRIBE, new PubSubOutput(this.codec), this.args(patterns));
    }

    @Override
    public void punsubscribe(K ... patterns) {
        this.dispatch(CommandType.PUNSUBSCRIBE, new PubSubOutput(this.codec), this.args(patterns));
    }

    @Override
    public void subscribe(K ... channels) {
        this.dispatch(CommandType.SUBSCRIBE, new PubSubOutput(this.codec), this.args(channels));
    }

    @Override
    public void unsubscribe(K ... channels) {
        this.dispatch(CommandType.UNSUBSCRIBE, new PubSubOutput(this.codec), this.args(channels));
    }

    @Override
    public void activated() {
        if (!this.channels.isEmpty()) {
            this.subscribe(this.toArray(this.channels));
            this.channels.clear();
        }
        if (!this.patterns.isEmpty()) {
            this.psubscribe(this.toArray(this.patterns));
            this.patterns.clear();
        }
    }

    @Override
    public void channelRead(Object msg) {
        PubSubOutput output = (PubSubOutput)msg;
        block8: for (RedisPubSubListener redisPubSubListener : this.listeners) {
            switch (output.type()) {
                case message: {
                    redisPubSubListener.message(output.channel(), output.get());
                    continue block8;
                }
                case pmessage: {
                    redisPubSubListener.message(output.pattern(), output.channel(), output.get());
                    continue block8;
                }
                case psubscribe: {
                    this.patterns.add(output.pattern());
                    redisPubSubListener.psubscribed(output.pattern(), output.count());
                    continue block8;
                }
                case punsubscribe: {
                    this.patterns.remove(output.pattern());
                    redisPubSubListener.punsubscribed(output.pattern(), output.count());
                    continue block8;
                }
                case subscribe: {
                    this.channels.add(output.channel());
                    redisPubSubListener.subscribed(output.channel(), output.count());
                    continue block8;
                }
                case unsubscribe: {
                    this.channels.remove(output.channel());
                    redisPubSubListener.unsubscribed(output.channel(), output.count());
                    continue block8;
                }
            }
            throw new UnsupportedOperationException("Operation " + (Object)((Object)output.type()) + " not supported");
        }
    }

    private CommandArgs<K, V> args(K ... keys) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKeys(keys);
        return args;
    }

    private <T> T[] toArray(Collection<T> c) {
        Class<?> cls = c.iterator().next().getClass();
        Object[] array = (Object[])Array.newInstance(cls, c.size());
        return c.toArray(array);
    }
}

