/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.support;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.support.LettuceFactoryBeanSupport;
import java.net.URI;

public class RedisClientFactoryBean
extends LettuceFactoryBeanSupport<RedisClient> {
    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.getRedisURI() == null) {
            String pathSuffix;
            URI uri = this.getUri();
            RedisURI.Builder builder = null;
            builder = uri.getScheme().equals("redis-sentinel") ? this.configureSentinel(uri, builder) : (uri.getPort() != -1 ? RedisURI.Builder.redis(uri.getHost(), uri.getPort()) : RedisURI.Builder.redis(uri.getHost()));
            if (LettuceStrings.isNotEmpty(this.getPassword())) {
                builder.withPassword(this.getPassword());
            }
            if (LettuceStrings.isNotEmpty(uri.getPath()) && LettuceStrings.isNotEmpty(pathSuffix = uri.getPath().substring(1))) {
                builder.withDatabase(Integer.parseInt(pathSuffix));
            }
            this.setRedisURI(builder.build());
        }
        super.afterPropertiesSet();
    }

    private RedisURI.Builder configureSentinel(URI uri, RedisURI.Builder builder) {
        Preconditions.checkArgument((boolean)LettuceStrings.isNotEmpty(uri.getFragment()), (Object)"URI Fragment must contain the sentinelMasterId");
        String masterId = uri.getFragment();
        if (LettuceStrings.isNotEmpty(uri.getHost())) {
            builder = uri.getPort() != -1 ? RedisURI.Builder.sentinel(uri.getHost(), uri.getPort(), masterId) : RedisURI.Builder.sentinel(uri.getHost(), masterId);
        }
        if (builder == null && LettuceStrings.isNotEmpty(uri.getAuthority())) {
            String[] hosts;
            for (String host : hosts = uri.getAuthority().split("\\,")) {
                HostAndPort hostAndPort = HostAndPort.fromString((String)host);
                if (builder == null) {
                    if (hostAndPort.hasPort()) {
                        builder = RedisURI.Builder.sentinel(hostAndPort.getHostText(), hostAndPort.getPort(), masterId);
                        continue;
                    }
                    builder = RedisURI.Builder.sentinel(hostAndPort.getHostText(), masterId);
                    continue;
                }
                if (hostAndPort.hasPort()) {
                    builder.withSentinel(hostAndPort.getHostText(), hostAndPort.getPort());
                    continue;
                }
                builder.withSentinel(hostAndPort.getHostText());
            }
        }
        Preconditions.checkArgument((builder != null ? 1 : 0) != 0, (Object)"Invalid URI, cannot get host part");
        return builder;
    }

    protected void destroyInstance(RedisClient instance) throws Exception {
        instance.shutdown();
    }

    public Class<?> getObjectType() {
        return RedisClient.class;
    }

    protected RedisClient createInstance() throws Exception {
        return new RedisClient(this.getRedisURI());
    }
}

