/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.support;

import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.cluster.RedisClusterClient;
import com.lambdaworks.redis.support.LettuceFactoryBeanSupport;
import java.net.URI;

public class RedisClusterClientFactoryBean
extends LettuceFactoryBeanSupport<RedisClusterClient> {
    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.getRedisURI() == null) {
            String pathSuffix;
            URI uri = this.getUri();
            RedisURI.Builder builder = null;
            if (uri.getScheme().equals("redis-sentinel")) {
                throw new IllegalArgumentException("Sentinel mode not supported when using RedisClusterClient");
            }
            builder = uri.getPort() != -1 ? RedisURI.Builder.redis(uri.getHost(), uri.getPort()) : RedisURI.Builder.redis(uri.getHost());
            if (LettuceStrings.isNotEmpty(this.getPassword())) {
                builder.withPassword(this.getPassword());
            }
            if (LettuceStrings.isNotEmpty(uri.getPath()) && LettuceStrings.isNotEmpty(pathSuffix = uri.getPath().substring(1))) {
                builder.withDatabase(Integer.parseInt(pathSuffix));
            }
            this.setRedisURI(builder.build());
        }
        super.afterPropertiesSet();
    }

    protected void destroyInstance(RedisClusterClient instance) throws Exception {
        instance.shutdown();
    }

    public Class<?> getObjectType() {
        return RedisClusterClient.class;
    }

    protected RedisClusterClient createInstance() throws Exception {
        return new RedisClusterClient(this.getRedisURI());
    }
}

