package com.lambdaworks.redis.cluster.api.async;

import com.lambdaworks.redis.RedisFuture;

/**
 * Asynchronous executed commands on a node selection for HyperLogLog (PF* commands).
 * 
 * @param <K> Key type.
 * @param <V> Value type.
 * @author <a href="mailto:mpaluch@paluch.biz">Mark Paluch</a>
 * @since 3.0
 * @generated by com.lambdaworks.apigenerator.CreateAsyncNodeSelectionClusterApi
 */
public interface NodeSelectionHLLAsyncCommands<K, V> {

    /**
     * Adds the specified elements to the specified HyperLogLog.
     *
     * @param key the key
     * @param values the values
     *
     * @return Long integer-reply specifically:
     *
     *         1 if at least 1 HyperLogLog internal register was altered. 0 otherwise.
     */
    AsyncExecutions<Long> pfadd(K key, V... values);

    /**
     * Merge N different HyperLogLogs into a single one.
     *
     * @param destkey the destination key
     * @param sourcekeys the source key
     *
     * @return Long simple-string-reply The command just returns {@code OK}.
     */
    AsyncExecutions<Long> pfmerge(K destkey, K... sourcekeys);

    /**
     * Return the approximated cardinality of the set(s) observed by the HyperLogLog at key(s).
     *
     * @param keys the keys
     *
     * @return Long integer-reply specifically:
     *
     *         The approximated number of unique elements observed via {@code PFADD}.
     */
    AsyncExecutions<Long> pfcount(K... keys);
}
