/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.AbstractInvocationHandler;
import com.lambdaworks.redis.LettuceFutures;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class FutureSyncInvocationHandler<K, V>
extends AbstractInvocationHandler {
    private final StatefulConnection<?, ?> connection;
    private final Object asyncApi;
    private LoadingCache<Method, Method> methodCache;

    public FutureSyncInvocationHandler(StatefulConnection<?, ?> connection, final Object asyncApi) {
        this.connection = connection;
        this.asyncApi = asyncApi;
        this.methodCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Method, Method>(){

            public Method load(Method key) throws Exception {
                return asyncApi.getClass().getMethod(key.getName(), key.getParameterTypes());
            }
        });
    }

    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Method targetMethod = (Method)this.methodCache.get((Object)method);
            Object result = targetMethod.invoke(this.asyncApi, args);
            if (result instanceof RedisFuture) {
                RedisFuture command = (RedisFuture)result;
                if (!method.getName().equals("exec") && !method.getName().equals("multi") && this.connection instanceof StatefulRedisConnection && ((StatefulRedisConnection)this.connection).isMulti()) {
                    return null;
                }
                LettuceFutures.awaitOrCancel(command, this.connection.getTimeout(), this.connection.getTimeoutUnit());
                return command.get();
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

