/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import com.lambdaworks.redis.ConnectionBuilder;
import com.lambdaworks.redis.ConnectionEventTrigger;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.PlainChannelInitializer;
import com.lambdaworks.redis.RedisChannelInitializer;
import com.lambdaworks.redis.RedisChannelInitializerImpl;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.event.EventBus;
import com.lambdaworks.redis.event.connection.ConnectedEvent;
import com.lambdaworks.redis.event.connection.ConnectionActivatedEvent;
import com.lambdaworks.redis.event.connection.DisconnectedEvent;
import com.lambdaworks.redis.protocol.AsyncCommand;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.util.List;
import java.util.concurrent.Future;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;

public class SslConnectionBuilder
extends ConnectionBuilder {
    private RedisURI redisURI;

    public static SslConnectionBuilder sslConnectionBuilder() {
        return new SslConnectionBuilder();
    }

    public SslConnectionBuilder ssl(RedisURI redisURI) {
        this.redisURI = redisURI;
        return this;
    }

    @Override
    protected List<ChannelHandler> buildHandlers() {
        Preconditions.checkState((this.redisURI != null ? 1 : 0) != 0, (Object)"redisURI must not be null");
        Preconditions.checkState((boolean)this.redisURI.isSsl(), (Object)"redisURI is not configured for SSL (ssl is false)");
        return super.buildHandlers();
    }

    @Override
    public RedisChannelInitializer build() {
        List<ChannelHandler> channelHandlers = this.buildHandlers();
        return new SslChannelInitializer(this.clientOptions().isPingBeforeActivateConnection(), channelHandlers, this.redisURI, this.clientResources().eventBus());
    }

    static class SslChannelInitializer
    extends ChannelInitializer<Channel>
    implements RedisChannelInitializer {
        private final boolean pingBeforeActivate;
        private final List<ChannelHandler> handlers;
        private final RedisURI redisURI;
        private final EventBus eventBus;
        private SettableFuture<Boolean> initializedFuture = SettableFuture.create();

        public SslChannelInitializer(boolean pingBeforeActivate, List<ChannelHandler> handlers, RedisURI redisURI, EventBus eventBus) {
            this.pingBeforeActivate = pingBeforeActivate;
            this.handlers = handlers;
            this.redisURI = redisURI;
            this.eventBus = eventBus;
        }

        protected void initChannel(Channel channel) throws Exception {
            SSLParameters sslParams = new SSLParameters();
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.JDK);
            if (this.redisURI.isVerifyPeer()) {
                sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            } else {
                sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            }
            SslContext sslContext = sslContextBuilder.build();
            SSLEngine sslEngine = sslContext.newEngine(channel.alloc(), this.redisURI.getHost(), this.redisURI.getPort());
            sslEngine.setSSLParameters(sslParams);
            PlainChannelInitializer.removeIfExists(channel.pipeline(), SslHandler.class);
            if (channel.pipeline().get("first") == null) {
                channel.pipeline().addFirst("first", (ChannelHandler)new ChannelDuplexHandler(){

                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        eventBus.publish(new ConnectedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
                        super.channelActive(ctx);
                    }

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        eventBus.publish(new DisconnectedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
                        super.channelInactive(ctx);
                    }
                });
            }
            SslHandler sslHandler = new SslHandler(sslEngine, this.redisURI.isStartTls());
            channel.pipeline().addLast(new ChannelHandler[]{sslHandler});
            if (channel.pipeline().get("channelActivator") == null) {
                channel.pipeline().addLast("channelActivator", (ChannelHandler)new RedisChannelInitializerImpl(){
                    private AsyncCommand<?, ?, ?> pingCommand;

                    @Override
                    public Future<Boolean> channelInitialized() {
                        return initializedFuture;
                    }

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        initializedFuture = SettableFuture.create();
                        this.pingCommand = null;
                        super.channelInactive(ctx);
                    }

                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        if (initializedFuture.isDone()) {
                            super.channelActive(ctx);
                        }
                    }

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt instanceof SslHandshakeCompletionEvent && !initializedFuture.isDone()) {
                            SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
                            if (event.isSuccess()) {
                                if (pingBeforeActivate) {
                                    this.pingCommand = redisURI.getPassword() != null && redisURI.getPassword().length != 0 ? new AsyncCommand<String, String, String>(PlainChannelInitializer.INITIALIZING_CMD_BUILDER.auth(new String(redisURI.getPassword()))) : new AsyncCommand<String, String, String>(PlainChannelInitializer.INITIALIZING_CMD_BUILDER.ping());
                                    PlainChannelInitializer.pingBeforeActivate(this.pingCommand, (SettableFuture<Boolean>)initializedFuture, ctx, handlers);
                                } else {
                                    ctx.fireChannelActive();
                                }
                            } else {
                                initializedFuture.setException(event.cause());
                            }
                        }
                        if (evt instanceof ConnectionEvents.Close && ctx.channel().isOpen()) {
                            ctx.channel().close();
                        }
                        if (evt instanceof ConnectionEvents.Activated && !initializedFuture.isDone()) {
                            initializedFuture.set((Object)true);
                            eventBus.publish(new ConnectionActivatedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
                        }
                        super.userEventTriggered(ctx, evt);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause instanceof SSLHandshakeException || cause.getCause() instanceof SSLException) {
                            initializedFuture.setException(cause);
                        }
                        super.exceptionCaught(ctx, cause);
                    }
                });
            }
            for (ChannelHandler handler : this.handlers) {
                PlainChannelInitializer.removeIfExists(channel.pipeline(), handler.getClass());
                channel.pipeline().addLast(new ChannelHandler[]{handler});
            }
        }

        @Override
        public Future<Boolean> channelInitialized() {
            return this.initializedFuture;
        }
    }
}

