/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.lambdaworks.redis.cluster.ClusterTopologyRefresh;
import com.lambdaworks.redis.cluster.RoundRobin;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.net.SocketAddress;
import java.util.Collection;

class RoundRobinSocketAddressSupplier
implements Supplier<SocketAddress> {
    protected final Collection<RedisClusterNode> clusterNodes = Lists.newArrayList();
    protected final Partitions partitions;
    protected RoundRobin<? extends RedisClusterNode> roundRobin;

    public RoundRobinSocketAddressSupplier(Partitions partitions) {
        Preconditions.checkArgument((partitions != null ? 1 : 0) != 0, (Object)"Partitions must not be null");
        this.partitions = partitions;
        this.roundRobin = new RoundRobin<RedisClusterNode>(this.clusterNodes);
        this.resetRoundRobin();
    }

    public SocketAddress get() {
        if (!this.clusterNodes.containsAll(this.partitions)) {
            this.resetRoundRobin();
        }
        RedisClusterNode redisClusterNode = this.roundRobin.next();
        return RoundRobinSocketAddressSupplier.getSocketAddress(redisClusterNode);
    }

    protected void resetRoundRobin() {
        this.clusterNodes.clear();
        this.clusterNodes.addAll(ClusterTopologyRefresh.createSortedList(this.partitions));
        this.roundRobin.offset = null;
    }

    protected static SocketAddress getSocketAddress(RedisClusterNode redisClusterNode) {
        return redisClusterNode.getUri().getResolvedAddress();
    }
}

