/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.models.slots;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.cluster.models.slots.ClusterSlotRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ClusterSlotsParser {
    private ClusterSlotsParser() {
    }

    public static List<ClusterSlotRange> parse(List<?> clusterSlotsOutput) {
        ArrayList result = Lists.newArrayList();
        HashMap nodeCache = Maps.newHashMap();
        for (Object o : clusterSlotsOutput) {
            List range;
            if (!(o instanceof List) || (range = (List)o).size() < 2) continue;
            ClusterSlotRange clusterSlotRange = ClusterSlotsParser.parseRange(range, nodeCache);
            result.add(clusterSlotRange);
        }
        Collections.sort(result, new Comparator<ClusterSlotRange>(){

            @Override
            public int compare(ClusterSlotRange o1, ClusterSlotRange o2) {
                return o1.getFrom() - o2.getFrom();
            }
        });
        return Collections.unmodifiableList(result);
    }

    private static ClusterSlotRange parseRange(List<?> range, Map<String, RedisClusterNode> nodeCache) {
        Iterator<?> iterator = range.iterator();
        int from = Ints.checkedCast((long)ClusterSlotsParser.getLongFromIterator(iterator, 0L));
        int to = Ints.checkedCast((long)ClusterSlotsParser.getLongFromIterator(iterator, 0L));
        RedisClusterNode master = null;
        ArrayList slaves = Lists.newArrayList();
        if (iterator.hasNext() && (master = ClusterSlotsParser.getRedisClusterNode(iterator, nodeCache)) != null) {
            master.setFlags(Collections.singleton(RedisClusterNode.NodeFlag.MASTER));
            TreeSet slots = Sets.newTreeSet(master.getSlots());
            slots.addAll(ClusterSlotsParser.createSlots(from, to));
            master.setSlots(Lists.newArrayList((Iterable)slots));
        }
        while (iterator.hasNext()) {
            RedisClusterNode slave = ClusterSlotsParser.getRedisClusterNode(iterator, nodeCache);
            if (slave == null) continue;
            slave.setSlaveOf(master.getNodeId());
            slave.setFlags(Collections.singleton(RedisClusterNode.NodeFlag.SLAVE));
            slaves.add(slave);
        }
        return new ClusterSlotRange(from, to, master, Collections.unmodifiableList(slaves));
    }

    private static List<Integer> createSlots(int from, int to) {
        ArrayList slots = Lists.newArrayList();
        for (int i = from; i < to + 1; ++i) {
            slots.add(i);
        }
        return slots;
    }

    private static RedisClusterNode getRedisClusterNode(Iterator<?> iterator, Map<String, RedisClusterNode> nodeCache) {
        Object element = iterator.next();
        RedisClusterNode redisClusterNode = null;
        if (element instanceof List) {
            List hostAndPortList = (List)element;
            if (hostAndPortList.size() < 2) {
                return null;
            }
            Iterator hostAndPortIterator = hostAndPortList.iterator();
            String host = (String)hostAndPortIterator.next();
            int port = Ints.checkedCast((long)ClusterSlotsParser.getLongFromIterator(hostAndPortIterator, 0L));
            if (hostAndPortIterator.hasNext()) {
                String nodeId = (String)hostAndPortIterator.next();
                redisClusterNode = nodeCache.get(nodeId);
                if (redisClusterNode == null) {
                    redisClusterNode = ClusterSlotsParser.createNode(host, port);
                    nodeCache.put(nodeId, redisClusterNode);
                    redisClusterNode.setNodeId(nodeId);
                }
            } else {
                String key = host + ":" + port;
                redisClusterNode = nodeCache.get(key);
                if (redisClusterNode == null) {
                    redisClusterNode = ClusterSlotsParser.createNode(host, port);
                    nodeCache.put(key, redisClusterNode);
                }
            }
        }
        return redisClusterNode;
    }

    private static RedisClusterNode createNode(String host, int port) {
        RedisClusterNode redisClusterNode = new RedisClusterNode();
        redisClusterNode.setUri(RedisURI.create(host, port));
        redisClusterNode.setSlots(new ArrayList<Integer>());
        return redisClusterNode;
    }

    private static long getLongFromIterator(Iterator<?> iterator, long defaultValue) {
        if (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
        }
        return defaultValue;
    }
}

