/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.codec;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.lambdaworks.redis.codec.ByteBufferInputStream;
import com.lambdaworks.redis.codec.RedisCodec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;

public class CompressionCodec {
    public static <K, V> RedisCodec<K, V> valueCompressor(RedisCodec<K, V> delegate, CompressionType compressionType) {
        Preconditions.checkArgument((delegate != null ? 1 : 0) != 0, (Object)"RedisCodec must not be null");
        Preconditions.checkArgument((compressionType != null ? 1 : 0) != 0, (Object)"CompressionType must not be null");
        return new CompressingValueCodecWrapper(delegate, compressionType);
    }

    public static enum CompressionType {
        GZIP,
        DEFLATE;

    }

    private static class CompressingValueCodecWrapper
    implements RedisCodec<Object, Object> {
        private RedisCodec<Object, Object> delegate;
        private CompressionType compressionType;

        public CompressingValueCodecWrapper(RedisCodec<Object, Object> delegate, CompressionType compressionType) {
            this.delegate = delegate;
            this.compressionType = compressionType;
        }

        @Override
        public Object decodeKey(ByteBuffer bytes) {
            return this.delegate.decodeKey(bytes);
        }

        @Override
        public Object decodeValue(ByteBuffer bytes) {
            try {
                return this.delegate.decodeValue(this.decompress(bytes));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public ByteBuffer encodeKey(Object key) {
            return this.delegate.encodeKey(key);
        }

        @Override
        public ByteBuffer encodeValue(Object value) {
            try {
                return this.compress(this.delegate.encodeValue(value));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer compress(ByteBuffer source) throws IOException {
            if (source.remaining() == 0) {
                return source;
            }
            ByteBufferInputStream sourceStream = new ByteBufferInputStream(source);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(source.remaining() / 2);
            DeflaterOutputStream compressor = null;
            if (this.compressionType == CompressionType.GZIP) {
                compressor = new GZIPOutputStream(outputStream);
            }
            if (this.compressionType == CompressionType.DEFLATE) {
                compressor = new DeflaterOutputStream(outputStream);
            }
            try {
                ByteStreams.copy((InputStream)sourceStream, (OutputStream)compressor);
            }
            finally {
                ((OutputStream)compressor).close();
            }
            return ByteBuffer.wrap(outputStream.toByteArray());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer decompress(ByteBuffer source) throws IOException {
            if (source.remaining() == 0) {
                return source;
            }
            ByteBufferInputStream sourceStream = new ByteBufferInputStream(source);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(source.remaining() * 2);
            InflaterInputStream decompressor = null;
            if (this.compressionType == CompressionType.GZIP) {
                decompressor = new GZIPInputStream(sourceStream);
            }
            if (this.compressionType == CompressionType.DEFLATE) {
                decompressor = new InflaterInputStream(sourceStream);
            }
            try {
                ByteStreams.copy((InputStream)decompressor, (OutputStream)outputStream);
            }
            finally {
                ((InputStream)decompressor).close();
            }
            return ByteBuffer.wrap(outputStream.toByteArray());
        }
    }
}

