/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.masterslave;

import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.masterslave.MasterSlaveChannelWriter;
import com.lambdaworks.redis.masterslave.MasterSlaveConnectionProvider;
import com.lambdaworks.redis.masterslave.MasterSlaveTopologyProvider;
import com.lambdaworks.redis.masterslave.MasterSlaveTopologyRefresh;
import com.lambdaworks.redis.masterslave.SentinelTopologyProvider;
import com.lambdaworks.redis.masterslave.StatefulRedisMasterSlaveConnection;
import com.lambdaworks.redis.masterslave.StatefulRedisMasterSlaveConnectionImpl;
import com.lambdaworks.redis.masterslave.TopologyProvider;

public class MasterSlave {
    public static <K, V> StatefulRedisMasterSlaveConnection<K, V> connect(RedisClient redisClient, RedisCodec<K, V> codec, RedisURI redisURI) {
        StatefulRedisConnection<K, V> masterConnection = redisClient.connect(codec, redisURI);
        TopologyProvider topologyProvider = redisURI.getSentinels().isEmpty() ? new MasterSlaveTopologyProvider(masterConnection, redisURI) : new SentinelTopologyProvider(redisURI.getSentinelMasterId(), redisClient, redisURI);
        MasterSlaveConnectionProvider<K, V> connectionProvider = new MasterSlaveConnectionProvider<K, V>(redisClient, codec, masterConnection, redisURI);
        MasterSlaveTopologyRefresh refresh = new MasterSlaveTopologyRefresh(redisClient, topologyProvider);
        connectionProvider.setKnownNodes(refresh.getNodes(redisURI));
        MasterSlaveChannelWriter channelWriter = new MasterSlaveChannelWriter(connectionProvider);
        StatefulRedisMasterSlaveConnectionImpl connection = new StatefulRedisMasterSlaveConnectionImpl(channelWriter, codec, redisURI.getTimeout(), redisURI.getUnit());
        return connection;
    }
}

