/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.masterslave;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lambdaworks.redis.ReadFrom;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.masterslave.MasterSlaveUtils;
import com.lambdaworks.redis.models.role.RedisInstance;
import com.lambdaworks.redis.models.role.RedisNodeDescription;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MasterSlaveConnectionProvider<K, V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MasterSlaveConnectionProvider.class);
    private final boolean debugEnabled;
    private final LoadingCache<ConnectionKey, StatefulRedisConnection<K, V>> connections;
    private final StatefulRedisConnection<K, V> masterConnection;
    private final RedisURI initialRedisUri;
    private List<RedisNodeDescription> knownNodes = Lists.newArrayList();
    private boolean autoFlushCommands = true;
    private Object stateLock = new Object();
    private ReadFrom readFrom;

    public MasterSlaveConnectionProvider(RedisClient redisClient, RedisCodec<K, V> redisCodec, StatefulRedisConnection<K, V> masterConnection, RedisURI initialRedisUri) {
        this.masterConnection = masterConnection;
        this.initialRedisUri = initialRedisUri;
        this.debugEnabled = logger.isDebugEnabled();
        this.connections = CacheBuilder.newBuilder().build(new ConnectionFactory<K, V>(redisClient, redisCodec));
    }

    public StatefulRedisConnection<K, V> getConnection(Intent intent) {
        if (this.debugEnabled) {
            logger.debug("getConnection(" + (Object)((Object)intent) + ")");
        }
        if (this.readFrom != null && intent == Intent.READ) {
            List<RedisNodeDescription> selection = this.readFrom.select(new ReadFrom.Nodes(){

                @Override
                public List<RedisNodeDescription> getNodes() {
                    return MasterSlaveConnectionProvider.this.knownNodes;
                }

                @Override
                public Iterator<RedisNodeDescription> iterator() {
                    return MasterSlaveConnectionProvider.this.knownNodes.iterator();
                }
            });
            if (selection.isEmpty()) {
                throw new RedisException("Cannot determine a node to read (Known nodes: " + this.knownNodes + ") with setting " + this.readFrom);
            }
            try {
                for (RedisNodeDescription redisNodeDescription : selection) {
                    StatefulRedisConnection<K, V> readerCandidate = this.getConnection(redisNodeDescription);
                    if (!readerCandidate.isOpen()) continue;
                    return readerCandidate;
                }
            }
            catch (RuntimeException e) {
                throw new RedisException(e);
            }
        }
        return this.masterConnection;
    }

    protected StatefulRedisConnection<K, V> getConnection(RedisNodeDescription redisNodeDescription) {
        if (redisNodeDescription.getRole() == RedisInstance.Role.MASTER) {
            return this.masterConnection;
        }
        return (StatefulRedisConnection)this.connections.getUnchecked((Object)new ConnectionKey(redisNodeDescription.getUri().getHost(), redisNodeDescription.getUri().getPort()));
    }

    protected long getConnectionCount() {
        return this.connections.size() + 1L;
    }

    private Set<ConnectionKey> getStaleConnectionKeys() {
        HashMap map = Maps.newHashMap((Map)this.connections.asMap());
        HashSet stale = Sets.newHashSet();
        for (ConnectionKey connectionKey : map.keySet()) {
            if (connectionKey.host != null && MasterSlaveUtils.findNodeByHostAndPort(this.knownNodes, connectionKey.host, connectionKey.port) != null) continue;
            stale.add(connectionKey);
        }
        return stale;
    }

    public void closeStaleConnections() {
        logger.debug("closeStaleConnections() count before expiring: {}", (Object)this.getConnectionCount());
        Set<ConnectionKey> stale = this.getStaleConnectionKeys();
        for (ConnectionKey connectionKey : stale) {
            StatefulRedisConnection connection = (StatefulRedisConnection)this.connections.getIfPresent((Object)connectionKey);
            if (connection == null) continue;
            this.connections.invalidate((Object)connectionKey);
            connection.close();
        }
        logger.debug("closeStaleConnections() count after expiring: {}", (Object)this.getConnectionCount());
    }

    public void reset() {
        this.allConnections().forEach(StatefulConnection::reset);
    }

    public void close() {
        this.allConnections().forEach(StatefulConnection::close);
        this.connections.invalidateAll();
    }

    public void flushCommands() {
        this.allConnections().forEach(StatefulConnection::flushCommands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoFlushCommands(boolean autoFlushCommands) {
        Object object = this.stateLock;
        synchronized (object) {
        }
        this.allConnections().forEach(connection -> connection.setAutoFlushCommands(autoFlushCommands));
    }

    protected Collection<StatefulRedisConnection<K, V>> allConnections() {
        return ImmutableSet.builder().addAll(this.connections.asMap().values()).add(this.masterConnection).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKnownNodes(Collection<RedisNodeDescription> knownNodes) {
        Object object = this.stateLock;
        synchronized (object) {
            this.knownNodes.clear();
            this.knownNodes.addAll(knownNodes);
            this.closeStaleConnections();
        }
    }

    public ReadFrom getReadFrom() {
        return this.readFrom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadFrom(ReadFrom readFrom) {
        Object object = this.stateLock;
        synchronized (object) {
            this.readFrom = readFrom;
        }
    }

    static enum Intent {
        READ,
        WRITE;

    }

    private static class ConnectionKey {
        private final String host;
        private final int port;

        public ConnectionKey(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConnectionKey)) {
                return false;
            }
            ConnectionKey that = (ConnectionKey)o;
            if (this.port != that.port) {
                return false;
            }
            return !(this.host == null ? that.host != null : !this.host.equals(that.host));
        }

        public int hashCode() {
            int result = this.host != null ? this.host.hashCode() : 0;
            result = 31 * result + this.port;
            return result;
        }
    }

    private class ConnectionFactory<K, V>
    extends CacheLoader<ConnectionKey, StatefulRedisConnection<K, V>> {
        private final RedisClient redisClient;
        private final RedisCodec<K, V> redisCodec;

        public ConnectionFactory(RedisClient redisClient, RedisCodec<K, V> redisCodec) {
            this.redisClient = redisClient;
            this.redisCodec = redisCodec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StatefulRedisConnection<K, V> load(ConnectionKey key) throws Exception {
            RedisURI.Builder builder = RedisURI.Builder.redis(key.host, key.port);
            if (MasterSlaveConnectionProvider.this.initialRedisUri.getPassword() != null && MasterSlaveConnectionProvider.this.initialRedisUri.getPassword().length != 0) {
                builder.withPassword(new String(MasterSlaveConnectionProvider.this.initialRedisUri.getPassword()));
            }
            builder.withDatabase(MasterSlaveConnectionProvider.this.initialRedisUri.getDatabase());
            StatefulRedisConnection<K, V> connection = this.redisClient.connect(this.redisCodec, builder.build());
            Object object = MasterSlaveConnectionProvider.this.stateLock;
            synchronized (object) {
                connection.setAutoFlushCommands(MasterSlaveConnectionProvider.this.autoFlushCommands);
            }
            return connection;
        }
    }
}

