/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.masterslave;

import com.google.common.collect.Lists;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.masterslave.RedisMasterSlaveNode;
import com.lambdaworks.redis.masterslave.SentinelTopologyProvider;
import com.lambdaworks.redis.masterslave.TopologyProvider;
import com.lambdaworks.redis.models.role.RedisInstance;
import com.lambdaworks.redis.models.role.RedisNodeDescription;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MasterSlaveTopologyProvider
implements TopologyProvider {
    public static final Pattern ROLE_PATTERN = Pattern.compile("^role\\:([a-z]+)$", 8);
    public static final Pattern SLAVE_PATTERN = Pattern.compile("^slave(\\d+)\\:([a-z\\,\\=\\d\\.]+)$", 8);
    public static final Pattern IP_PATTERN = Pattern.compile("ip\\=([a-z\\d\\.]+)");
    public static final Pattern PORT_PATTERN = Pattern.compile("port\\=([\\d]+)");
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SentinelTopologyProvider.class);
    private final StatefulRedisConnection<?, ?> masterConnection;
    private final RedisURI masterURI;

    public MasterSlaveTopologyProvider(StatefulRedisConnection<?, ?> masterConnection, RedisURI masterURI) {
        this.masterConnection = masterConnection;
        this.masterURI = masterURI;
    }

    @Override
    public List<RedisNodeDescription> getNodes() {
        logger.debug("lookup topology");
        String info = this.masterConnection.sync().info("replication");
        try {
            return this.getNodesFromInfo(info);
        }
        catch (RuntimeException e) {
            throw new RedisException(e);
        }
    }

    protected List<RedisNodeDescription> getNodesFromInfo(String info) {
        ArrayList result = Lists.newArrayList();
        result.add(this.getMasterFromInfo(info));
        result.addAll(this.getSlavesFromInfo(info));
        return result;
    }

    private List<RedisNodeDescription> getSlavesFromInfo(String info) {
        ArrayList slaves = Lists.newArrayList();
        Matcher matcher = SLAVE_PATTERN.matcher(info);
        while (matcher.find()) {
            String group = matcher.group(2);
            String ip = this.getNested(IP_PATTERN, group, 1);
            String port = this.getNested(PORT_PATTERN, group, 1);
            slaves.add(new RedisMasterSlaveNode(ip, Integer.parseInt(port), RedisInstance.Role.SLAVE));
        }
        return slaves;
    }

    private String getNested(Pattern pattern, String string, int group) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(group);
        }
        throw new IllegalArgumentException("Cannot extract group " + group + " with patter " + pattern + " from " + string);
    }

    private RedisNodeDescription getMasterFromInfo(String info) {
        Matcher matcher = ROLE_PATTERN.matcher(info);
        if (!matcher.find()) {
            throw new IllegalStateException("No role property in info " + info);
        }
        String roleString = matcher.group(1);
        RedisInstance.Role role = null;
        if (RedisInstance.Role.MASTER.name().equalsIgnoreCase(roleString)) {
            role = RedisInstance.Role.MASTER;
        }
        if (RedisInstance.Role.SLAVE.name().equalsIgnoreCase(roleString)) {
            role = RedisInstance.Role.SLAVE;
        }
        if (role == null) {
            throw new IllegalStateException("Cannot resolve role " + roleString + " to " + (Object)((Object)RedisInstance.Role.MASTER) + " or " + (Object)((Object)RedisInstance.Role.SLAVE));
        }
        return new RedisMasterSlaveNode(this.masterURI.getHost(), this.masterURI.getPort(), role);
    }
}

