/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.masterslave;

import com.google.common.collect.Lists;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.masterslave.MasterSlaveUtils;
import com.lambdaworks.redis.masterslave.RedisMasterSlaveNode;
import com.lambdaworks.redis.masterslave.TopologyProvider;
import com.lambdaworks.redis.models.role.RedisInstance;
import com.lambdaworks.redis.models.role.RedisNodeDescription;
import com.lambdaworks.redis.sentinel.api.StatefulRedisSentinelConnection;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class SentinelTopologyProvider
implements TopologyProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SentinelTopologyProvider.class);
    private final String masterId;
    private final RedisClient redisClient;
    private final RedisURI sentinelUri;
    private final long timeout;
    private final TimeUnit timeUnit;

    public SentinelTopologyProvider(String masterId, RedisClient redisClient, RedisURI sentinelUri) {
        this.masterId = masterId;
        this.redisClient = redisClient;
        this.sentinelUri = sentinelUri;
        this.timeout = sentinelUri.getTimeout();
        this.timeUnit = sentinelUri.getUnit();
    }

    @Override
    public List<RedisNodeDescription> getNodes() {
        logger.debug("lookup topology for masterId {}", (Object)this.masterId);
        try (StatefulRedisSentinelConnection<String, String> connection = this.redisClient.connectSentinel(MasterSlaveUtils.CODEC, this.sentinelUri);){
            RedisFuture<Map<String, String>> masterFuture = connection.async().master(this.masterId);
            RedisFuture<List<Map<String, String>>> slavesFuture = connection.async().slaves(this.masterId);
            ArrayList result = Lists.newArrayList();
            try {
                Map master = (Map)masterFuture.get(this.timeout, this.timeUnit);
                List slaves = (List)slavesFuture.get(this.timeout, this.timeUnit);
                result.add(this.toNode(master, RedisInstance.Role.MASTER));
                result.addAll(slaves.stream().map(map -> this.toNode((Map<String, String>)map, RedisInstance.Role.SLAVE)).collect(Collectors.toList()));
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RedisException(e);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
    }

    private RedisNodeDescription toNode(Map<String, String> map, RedisInstance.Role role) {
        String ip = map.get("ip");
        String port = map.get("port");
        return new RedisMasterSlaveNode(ip, Integer.parseInt(port), role);
    }
}

