/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.google.common.collect.Lists;
import com.lambdaworks.redis.GeoCoordinates;
import com.lambdaworks.redis.GeoWithin;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.CommandOutput;
import java.nio.ByteBuffer;
import java.util.List;

public class GeoWithinListOutput<K, V>
extends CommandOutput<K, V, List<GeoWithin<V>>> {
    private V member;
    private Double distance;
    private Long geohash;
    private GeoCoordinates coordinates;
    private Double x;
    private boolean withDistance;
    private boolean withHash;
    private boolean withCoordinates;

    public GeoWithinListOutput(RedisCodec<K, V> codec, boolean withDistance, boolean withHash, boolean withCoordinates) {
        super(codec, null);
        this.withDistance = withDistance;
        this.withHash = withHash;
        this.withCoordinates = withCoordinates;
    }

    @Override
    public void set(long integer) {
        if (this.member == null) {
            this.member = integer;
            return;
        }
        if (this.withHash) {
            this.geohash = integer;
        }
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.member == null) {
            this.member = this.codec.decodeValue(bytes);
            return;
        }
        Double value = bytes == null ? 0.0 : Double.parseDouble(this.decodeAscii(bytes));
        if (this.withDistance && this.distance == null) {
            this.distance = value;
            return;
        }
        if (this.withCoordinates) {
            if (this.x == null) {
                this.x = value;
                return;
            }
            this.coordinates = new GeoCoordinates(this.x, value);
            return;
        }
    }

    @Override
    public void multi(int count) {
        if (this.output == null) {
            this.output = Lists.newArrayListWithCapacity((int)count);
        }
    }

    @Override
    public void complete(int depth) {
        if (depth == 1) {
            ((List)this.output).add(new GeoWithin<V>(this.member, this.distance, this.geohash, this.coordinates));
            this.member = null;
            this.distance = null;
            this.geohash = null;
            this.coordinates = null;
        }
    }
}

