/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.google.common.base.Preconditions;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.LettuceCharsets;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.netty.buffer.ByteBuf;

public class Command<K, V, T>
implements RedisCommand<K, V, T> {
    private static final byte[] CRLF = "\r\n".getBytes(LettuceCharsets.ASCII);
    private final ProtocolKeyword type;
    protected CommandArgs<K, V> args;
    protected CommandOutput<K, V, T> output;
    protected Throwable exception;
    protected boolean cancelled = false;
    protected boolean completed = false;

    public Command(ProtocolKeyword type, CommandOutput<K, V, T> output) {
        this(type, output, null);
    }

    public Command(ProtocolKeyword type, CommandOutput<K, V, T> output, CommandArgs<K, V> args) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Command type must not be null");
        this.type = type;
        this.output = output;
        this.args = args;
    }

    @Override
    public CommandOutput<K, V, T> getOutput() {
        return this.output;
    }

    @Override
    public boolean completeExceptionally(Throwable throwable) {
        if (this.output != null) {
            this.output.setError(throwable.getMessage());
        }
        this.exception = throwable;
        return true;
    }

    @Override
    public void complete() {
        this.completed = true;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeByte(42);
        Command.writeInt(buf, 1 + (this.args != null ? this.args.count() : 0));
        buf.writeBytes(CRLF);
        buf.writeByte(36);
        Command.writeInt(buf, this.type.getBytes().length);
        buf.writeBytes(CRLF);
        buf.writeBytes(this.type.getBytes());
        buf.writeBytes(CRLF);
        if (this.args != null) {
            buf.writeBytes(this.args.buffer());
        }
    }

    protected static void writeInt(ByteBuf buf, int value) {
        if (value < 10) {
            buf.writeByte((int)((byte)(48 + value)));
            return;
        }
        String asString = Integer.toString(value);
        for (int i = 0; i < asString.length(); ++i) {
            buf.writeByte((int)((byte)asString.charAt(i)));
        }
    }

    public String getError() {
        return this.output.getError();
    }

    @Override
    public CommandArgs<K, V> getArgs() {
        return this.args;
    }

    public T get() {
        if (this.output != null) {
            return this.output.get();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [type=").append(this.type);
        sb.append(", output=").append(this.output);
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void setOutput(CommandOutput<K, V, T> output) {
        if (this.isCancelled() || this.completed) {
            throw new IllegalStateException("Command is completed/cancelled. Cannot set a new output");
        }
        this.output = output;
    }

    @Override
    public ProtocolKeyword getType() {
        return this.type;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.completed;
    }
}

