/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.google.common.base.Preconditions;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.protocol.LettuceCharsets;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Map;

public class CommandArgs<K, V> {
    private static final byte[] CRLF = "\r\n".getBytes(LettuceCharsets.ASCII);
    private final RedisCodec<K, V> codec;
    private ByteBuffer buffer;
    private ByteBuffer firstEncodedKey;
    private int count;
    private Long firstInteger;
    private String firstString;

    public CommandArgs(RedisCodec<K, V> codec) {
        Preconditions.checkArgument((codec != null ? 1 : 0) != 0, (Object)"RedisCodec must not be null");
        this.codec = codec;
        this.buffer = ByteBuffer.allocate(32);
    }

    ByteBuffer buffer() {
        this.buffer.flip();
        return this.buffer;
    }

    public int count() {
        return this.count;
    }

    public CommandArgs<K, V> addKey(K key) {
        if (this.firstEncodedKey == null) {
            this.firstEncodedKey = this.codec.encodeKey(key);
            return this.write(this.firstEncodedKey.duplicate());
        }
        return this.write(this.codec.encodeKey(key));
    }

    public CommandArgs<K, V> addKeys(Iterable<K> keys) {
        for (K key : keys) {
            this.addKey(key);
        }
        return this;
    }

    public CommandArgs<K, V> addKeys(K ... keys) {
        for (K key : keys) {
            this.addKey(key);
        }
        return this;
    }

    public CommandArgs<K, V> addValue(V value) {
        return this.write(this.codec.encodeValue(value));
    }

    public CommandArgs<K, V> addValues(V ... values) {
        for (V value : values) {
            this.addValue(value);
        }
        return this;
    }

    public CommandArgs<K, V> add(Map<K, V> map) {
        if (map.size() > 2) {
            this.realloc(this.buffer.capacity() + 16 * map.size());
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (this.firstEncodedKey == null) {
                this.firstEncodedKey = this.codec.encodeKey(entry.getKey());
                this.write(this.firstEncodedKey.duplicate());
            } else {
                this.write(this.codec.encodeKey(entry.getKey()));
            }
            this.write(this.codec.encodeValue(entry.getValue()));
        }
        return this;
    }

    public CommandArgs<K, V> add(String s) {
        if (this.firstString == null) {
            this.firstString = s;
        }
        return this.write(s);
    }

    public CommandArgs<K, V> add(long n) {
        if (this.firstInteger == null) {
            this.firstInteger = n;
        }
        return this.write(Long.toString(n));
    }

    public CommandArgs<K, V> add(double n) {
        return this.write(Double.toString(n));
    }

    public CommandArgs<K, V> add(byte[] value) {
        return this.write(value);
    }

    public CommandArgs<K, V> add(CommandKeyword keyword) {
        return this.write(keyword.bytes);
    }

    public CommandArgs<K, V> add(CommandType type) {
        return this.write(type.bytes);
    }

    public CommandArgs<K, V> add(ProtocolKeyword keyword) {
        return this.write(keyword.getBytes());
    }

    private CommandArgs<K, V> write(ByteBuffer arg) {
        this.buffer.mark();
        if (this.buffer.remaining() < arg.remaining()) {
            int estimate = this.buffer.remaining() + arg.remaining() + 10;
            this.realloc(Math.max(this.buffer.capacity() * 2, estimate));
        }
        while (true) {
            try {
                ByteBuffer toWrite = arg.duplicate();
                this.buffer.put((byte)36);
                this.write(toWrite.remaining());
                this.buffer.put(CRLF);
                this.buffer.put(toWrite);
                this.buffer.put(CRLF);
            }
            catch (BufferOverflowException e) {
                this.buffer.reset();
                this.realloc(this.buffer.capacity() * 2);
                continue;
            }
            break;
        }
        ++this.count;
        return this;
    }

    private CommandArgs<K, V> write(byte[] arg) {
        this.buffer.mark();
        if (this.buffer.remaining() < arg.length) {
            int estimate = this.buffer.remaining() + arg.length + 10;
            this.realloc(Math.max(this.buffer.capacity() * 2, estimate));
        }
        while (true) {
            try {
                this.buffer.put((byte)36);
                this.write(arg.length);
                this.buffer.put(CRLF);
                this.buffer.put(arg);
                this.buffer.put(CRLF);
            }
            catch (BufferOverflowException e) {
                this.buffer.reset();
                this.realloc(this.buffer.capacity() * 2);
                continue;
            }
            break;
        }
        ++this.count;
        return this;
    }

    private CommandArgs<K, V> write(String arg) {
        int length = arg.length();
        this.buffer.mark();
        if (this.buffer.remaining() < length) {
            int estimate = this.buffer.remaining() + length + 10;
            this.realloc(Math.max(this.buffer.capacity() * 2, estimate));
        }
        while (true) {
            try {
                this.buffer.put((byte)36);
                this.write(length);
                this.buffer.put(CRLF);
                for (int i = 0; i < length; ++i) {
                    this.buffer.put((byte)arg.charAt(i));
                }
                this.buffer.put(CRLF);
            }
            catch (BufferOverflowException e) {
                this.buffer.reset();
                this.realloc(this.buffer.capacity() * 2);
                continue;
            }
            break;
        }
        ++this.count;
        return this;
    }

    private void write(int value) {
        if (value < 10) {
            this.buffer.put((byte)(48 + value));
            return;
        }
        String asString = Integer.toString(value);
        for (int i = 0; i < asString.length(); ++i) {
            this.buffer.put((byte)asString.charAt(i));
        }
    }

    private void realloc(int size) {
        ByteBuffer newBuffer = ByteBuffer.allocate(size);
        this.buffer.flip();
        newBuffer.put(this.buffer);
        newBuffer.mark();
        this.buffer = newBuffer;
    }

    public ByteBuffer getFirstEncodedKey() {
        if (this.firstEncodedKey != null) {
            return this.firstEncodedKey.duplicate();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [buffer=").append(new String(this.buffer.array()));
        sb.append(']');
        return sb.toString();
    }

    public Long getFirstInteger() {
        return this.firstInteger;
    }

    public String getFirstString() {
        return this.firstString;
    }
}

