/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.sentinel;

import com.google.common.base.Preconditions;
import com.lambdaworks.redis.ReactiveCommandDispatcher;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.protocol.RedisCommand;
import com.lambdaworks.redis.sentinel.SentinelCommandBuilder;
import com.lambdaworks.redis.sentinel.api.StatefulRedisSentinelConnection;
import com.lambdaworks.redis.sentinel.api.rx.RedisSentinelReactiveCommands;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.function.Supplier;
import rx.Observable;

public class RedisSentinelReactiveCommandsImpl<K, V>
implements RedisSentinelReactiveCommands<K, V> {
    private final SentinelCommandBuilder<K, V> commandBuilder;
    private final StatefulConnection<K, V> connection;

    public RedisSentinelReactiveCommandsImpl(StatefulConnection<K, V> connection, RedisCodec<K, V> codec) {
        this.connection = connection;
        this.commandBuilder = new SentinelCommandBuilder<K, V>(codec);
    }

    @Override
    public Observable<SocketAddress> getMasterAddrByName(K key) {
        Observable observable = this.createObservable(() -> this.commandBuilder.getMasterAddrByKey(key));
        return observable.map(list -> {
            if (list.isEmpty()) {
                return null;
            }
            Preconditions.checkArgument((list.size() == 2 ? 1 : 0) != 0, (Object)"List must contain exact 2 entries (Hostname, Port)");
            String hostname = (String)list.get(0);
            String port = (String)list.get(1);
            return new InetSocketAddress(hostname, Integer.parseInt(port));
        });
    }

    @Override
    public Observable<Map<K, V>> masters() {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.masters());
    }

    @Override
    public Observable<Map<K, V>> master(K key) {
        return this.createObservable(() -> this.commandBuilder.master(key));
    }

    @Override
    public Observable<Map<K, V>> slaves(K key) {
        return (Observable)this.createDissolvingObservable(() -> this.commandBuilder.slaves(key));
    }

    @Override
    public Observable<Long> reset(K key) {
        return this.createObservable(() -> this.commandBuilder.reset(key));
    }

    @Override
    public Observable<String> failover(K key) {
        return this.createObservable(() -> this.commandBuilder.failover(key));
    }

    @Override
    public Observable<String> monitor(K key, String ip, int port, int quorum) {
        return this.createObservable(() -> this.commandBuilder.monitor(key, ip, port, quorum));
    }

    @Override
    public Observable<String> set(K key, String option, V value) {
        return this.createObservable(() -> this.commandBuilder.set(key, option, value));
    }

    @Override
    public Observable<String> remove(K key) {
        return this.createObservable(() -> this.commandBuilder.remove(key));
    }

    @Override
    public Observable<String> ping() {
        return this.createObservable(() -> this.commandBuilder.ping());
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public boolean isOpen() {
        return this.connection.isOpen();
    }

    @Override
    public StatefulRedisSentinelConnection<K, V> getStatefulConnection() {
        return (StatefulRedisSentinelConnection)this.connection;
    }

    public <T> Observable<T> createObservable(Supplier<RedisCommand<K, V, T>> commandSupplier) {
        return Observable.create(new ReactiveCommandDispatcher<K, V, T>(commandSupplier, this.connection, false));
    }

    public <T, R> R createDissolvingObservable(Supplier<RedisCommand<K, V, T>> commandSupplier) {
        return (R)Observable.create(new ReactiveCommandDispatcher<K, V, T>(commandSupplier, this.connection, true));
    }
}

