/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.internal;

import com.lambdaworks.redis.internal.LettuceAssert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LettuceLists {
    private LettuceLists() {
    }

    @SafeVarargs
    public static final <T> List<T> newList(T ... elements) {
        LettuceAssert.notNull(elements, "Elements must not be null");
        ArrayList<T> list = new ArrayList<T>(elements.length);
        for (T element : elements) {
            list.add(element);
        }
        return list;
    }

    public static final <E> List<E> newList(Iterable<? extends E> elements) {
        LettuceAssert.notNull(elements, "Iterable must not be null");
        if (elements instanceof Collection) {
            return new ArrayList((Collection)elements);
        }
        return LettuceLists.newList(elements.iterator());
    }

    public static final <E> List<E> newList(Iterator<? extends E> elements) {
        LettuceAssert.notNull(elements, "Iterator must not be null");
        ArrayList<E> objects = new ArrayList<E>();
        while (elements.hasNext()) {
            objects.add(elements.next());
        }
        return objects;
    }

    public static <E> List<E> unmodifiableList(E ... elements) {
        return Collections.unmodifiableList(LettuceLists.newList(elements));
    }

    public static <E> List<E> unmodifiableList(Collection<? extends E> elements) {
        return Collections.unmodifiableList(new ArrayList<E>(elements));
    }
}

