/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.models.role;

import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.models.role.RedisInstance;
import com.lambdaworks.redis.models.role.ReplicationPartner;
import java.io.Serializable;

public class RedisSlaveInstance
implements RedisInstance,
Serializable {
    private ReplicationPartner master;
    private State state;

    public RedisSlaveInstance() {
    }

    RedisSlaveInstance(ReplicationPartner master, State state) {
        LettuceAssert.notNull(master, "master must not be null");
        LettuceAssert.notNull((Object)state, "state must not be null");
        this.master = master;
        this.state = state;
    }

    @Override
    public RedisInstance.Role getRole() {
        return RedisInstance.Role.SLAVE;
    }

    public ReplicationPartner getMaster() {
        return this.master;
    }

    public State getState() {
        return this.state;
    }

    public void setMaster(ReplicationPartner master) {
        LettuceAssert.notNull(master, "master must not be null");
        this.master = master;
    }

    public void setState(State state) {
        LettuceAssert.notNull((Object)state, "state must not be null");
        this.state = state;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [master=").append(this.master);
        sb.append(", state=").append((Object)this.state);
        sb.append(']');
        return sb.toString();
    }

    public static enum State {
        CONNECT,
        CONNECTING,
        SYNC,
        CONNECTED;

    }
}

