/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.ReadFrom;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.ClusterNodeCommandHandler;
import com.lambdaworks.redis.cluster.RedisClusterClient;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.HostAndPort;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.internal.LettuceLists;
import com.lambdaworks.redis.models.role.RedisInstance;
import com.lambdaworks.redis.models.role.RedisNodeDescription;
import com.lambdaworks.redis.resource.SocketAddressResolver;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class PooledClusterConnectionProvider<K, V>
implements ClusterConnectionProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PooledClusterConnectionProvider.class);
    private final Map<ConnectionKey, StatefulRedisConnection<K, V>> connections = new ConcurrentHashMap<ConnectionKey, StatefulRedisConnection<K, V>>();
    private final Object stateLock = new Object();
    private final boolean debugEnabled = logger.isDebugEnabled();
    private final StatefulRedisConnection<K, V>[] writers = new StatefulRedisConnection[16384];
    private final StatefulRedisConnection<K, V>[][] readers = new StatefulRedisConnection[16384][];
    private final RedisClusterClient redisClusterClient;
    private final ConnectionFactory connectionFactory;
    private Partitions partitions;
    private boolean autoFlushCommands = true;
    private ReadFrom readFrom;

    public PooledClusterConnectionProvider(RedisClusterClient redisClusterClient, RedisChannelWriter<K, V> clusterWriter, RedisCodec<K, V> redisCodec) {
        this.redisClusterClient = redisClusterClient;
        this.connectionFactory = new ConnectionFactory(redisClusterClient, redisCodec, clusterWriter);
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(ClusterConnectionProvider.Intent intent, int slot) {
        if (this.debugEnabled) {
            logger.debug("getConnection(" + (Object)((Object)intent) + ", " + slot + ")");
        }
        try {
            if (intent == ClusterConnectionProvider.Intent.READ && this.readFrom != null) {
                return this.getReadConnection(slot);
            }
            return this.getWriteConnection(slot);
        }
        catch (RedisException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RedisException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatefulRedisConnection<K, V> getWriteConnection(int slot) {
        StatefulRedisConnection<K, V> writer;
        Object object = this.stateLock;
        synchronized (object) {
            writer = this.writers[slot];
        }
        if (writer == null) {
            RedisClusterNode partition = this.partitions.getPartitionBySlot(slot);
            if (partition == null) {
                throw new RedisException("Cannot determine a partition for slot " + slot + " (Partitions: " + this.partitions + ")");
            }
            RedisURI uri = partition.getUri();
            ConnectionKey key = new ConnectionKey(ClusterConnectionProvider.Intent.WRITE, uri.getHost(), uri.getPort());
            this.writers[slot] = this.getOrCreateConnection(key);
            return this.writers[slot];
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatefulRedisConnection<K, V> getReadConnection(int slot) {
        StatefulRedisConnection<K, V>[] statefulRedisConnectionArray = this.stateLock;
        synchronized (this.stateLock) {
            StatefulRedisConnection<K, V>[] readerCandidates = this.readers[slot];
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (readerCandidates == null) {
                RedisClusterNode master = this.partitions.getPartitionBySlot(slot);
                if (master == null) {
                    throw new RedisException("Cannot determine a partition to read for slot " + slot + " (Partitions: " + this.partitions + ")");
                }
                final List<RedisNodeDescription> candidates = this.getReadCandidates(master);
                List<RedisNodeDescription> selection = this.readFrom.select(new ReadFrom.Nodes(){

                    @Override
                    public List<RedisNodeDescription> getNodes() {
                        return candidates;
                    }

                    @Override
                    public Iterator<RedisNodeDescription> iterator() {
                        return candidates.iterator();
                    }
                });
                if (selection.isEmpty()) {
                    throw new RedisException("Cannot determine a partition to read for slot " + slot + " (Partitions: " + this.partitions + ") with setting " + this.readFrom);
                }
                readerCandidates = this.getReadFromConnections(selection);
                this.readers[slot] = readerCandidates;
            }
            for (StatefulRedisConnection<K, V> readerCandidate : readerCandidates) {
                if (!readerCandidate.isOpen()) continue;
                return readerCandidate;
            }
            return readerCandidates[0];
        }
    }

    private StatefulRedisConnection<K, V>[] getReadFromConnections(List<RedisNodeDescription> selection) {
        StatefulRedisConnection[] readerCandidates = new StatefulRedisConnection[selection.size()];
        for (int i = 0; i < selection.size(); ++i) {
            RedisNodeDescription redisClusterNode = selection.get(i);
            RedisURI uri = redisClusterNode.getUri();
            ConnectionKey key = new ConnectionKey(redisClusterNode.getRole() == RedisInstance.Role.MASTER ? ClusterConnectionProvider.Intent.WRITE : ClusterConnectionProvider.Intent.READ, uri.getHost(), uri.getPort());
            readerCandidates[i] = this.getOrCreateConnection(key);
        }
        return readerCandidates;
    }

    private List<RedisNodeDescription> getReadCandidates(RedisClusterNode master) {
        return this.partitions.stream().filter(partition -> this.isReadCandidate(master, (RedisClusterNode)partition)).collect(Collectors.toList());
    }

    private boolean isReadCandidate(RedisClusterNode master, RedisClusterNode partition) {
        return master.getNodeId().equals(partition.getNodeId()) || master.getNodeId().equals(partition.getSlaveOf());
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(ClusterConnectionProvider.Intent intent, String nodeId) {
        if (this.debugEnabled) {
            logger.debug("getConnection(" + (Object)((Object)intent) + ", " + nodeId + ")");
        }
        ConnectionKey key = new ConnectionKey(intent, nodeId);
        return this.getOrCreateConnection(key);
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(ClusterConnectionProvider.Intent intent, String host, int port) {
        try {
            RedisClusterNode redisClusterNode;
            if (this.debugEnabled) {
                logger.debug("getConnection(" + (Object)((Object)intent) + ", " + host + ", " + port + ")");
            }
            if (this.validateClusterNodeMembership() && (redisClusterNode = this.getPartition(host, port)) == null) {
                HostAndPort hostAndPort = HostAndPort.of(host, port);
                throw this.invalidConnectionPoint(hostAndPort.toString());
            }
            ConnectionKey key = new ConnectionKey(intent, host, port);
            return this.getOrCreateConnection(key);
        }
        catch (RedisException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RedisException(e);
        }
    }

    private RedisClusterNode getPartition(String host, int port) {
        for (RedisClusterNode partition : this.partitions) {
            RedisURI uri = partition.getUri();
            if (port != uri.getPort() || !host.equals(uri.getHost())) continue;
            return partition;
        }
        return null;
    }

    @Override
    public void close() {
        this.connections.clear();
        this.resetFastConnectionCache();
        new HashMap<ConnectionKey, StatefulRedisConnection<K, V>>(this.connections).values().stream().filter(StatefulConnection::isOpen).forEach(StatefulConnection::close);
    }

    @Override
    public void reset() {
        this.allConnections().forEach(StatefulConnection::reset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPartitions(Partitions partitions) {
        boolean reconfigurePartitions = false;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.partitions != null) {
                reconfigurePartitions = true;
            }
            this.partitions = partitions;
        }
        if (reconfigurePartitions) {
            this.reconfigurePartitions();
        }
    }

    private void reconfigurePartitions() {
        if (!this.redisClusterClient.expireStaleConnections()) {
            return;
        }
        Set<ConnectionKey> staleConnections = this.getStaleConnectionKeys();
        for (ConnectionKey key : staleConnections) {
            StatefulRedisConnection<K, V> connection = this.connections.get(key);
            RedisChannelHandler redisChannelHandler = (RedisChannelHandler)((Object)connection);
            if (!(redisChannelHandler.getChannelWriter() instanceof ClusterNodeCommandHandler)) continue;
            ClusterNodeCommandHandler clusterNodeCommandHandler = (ClusterNodeCommandHandler)redisChannelHandler.getChannelWriter();
            clusterNodeCommandHandler.prepareClose();
        }
        this.resetFastConnectionCache();
        this.closeStaleConnections();
    }

    @Override
    public void closeStaleConnections() {
        logger.debug("closeStaleConnections() count before expiring: {}", (Object)this.getConnectionCount());
        Set<ConnectionKey> stale = this.getStaleConnectionKeys();
        for (ConnectionKey connectionKey : stale) {
            StatefulRedisConnection<K, V> connection = this.connections.get(connectionKey);
            if (connection == null) continue;
            this.connections.remove(connectionKey);
            connection.close();
        }
        logger.debug("closeStaleConnections() count after expiring: {}", (Object)this.getConnectionCount());
    }

    private Set<ConnectionKey> getStaleConnectionKeys() {
        HashMap<ConnectionKey, StatefulRedisConnection<K, V>> map = new HashMap<ConnectionKey, StatefulRedisConnection<K, V>>(this.connections);
        HashSet<ConnectionKey> stale = new HashSet<ConnectionKey>();
        for (ConnectionKey connectionKey : map.keySet()) {
            if (connectionKey.nodeId != null && this.partitions.getPartitionByNodeId(connectionKey.nodeId) != null || connectionKey.host != null && this.getPartition(connectionKey.host, connectionKey.port) != null) continue;
            stale.add(connectionKey);
        }
        return stale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        Object object = this.stateLock;
        synchronized (object) {
            this.autoFlushCommands = autoFlush;
        }
        this.allConnections().forEach(connection -> connection.setAutoFlushCommands(autoFlush));
    }

    private Collection<StatefulRedisConnection<K, V>> allConnections() {
        return LettuceLists.unmodifiableList(this.connections.values());
    }

    @Override
    public void flushCommands() {
        this.allConnections().forEach(StatefulConnection::flushCommands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadFrom(ReadFrom readFrom) {
        Object object = this.stateLock;
        synchronized (object) {
            this.readFrom = readFrom;
            Arrays.fill(this.readers, null);
        }
    }

    @Override
    public ReadFrom getReadFrom() {
        return this.readFrom;
    }

    long getConnectionCount() {
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetFastConnectionCache() {
        Object object = this.stateLock;
        synchronized (object) {
            Arrays.fill(this.writers, null);
            Arrays.fill(this.readers, null);
        }
    }

    private RuntimeException invalidConnectionPoint(String message) {
        return new IllegalArgumentException("Connection to " + message + " not allowed. This connection point is not known in the cluster view");
    }

    private Supplier<SocketAddress> getSocketAddressSupplier(ConnectionKey connectionKey) {
        return () -> {
            if (connectionKey.nodeId != null) {
                SocketAddress socketAddress = this.getSocketAddress(connectionKey.nodeId);
                logger.debug("Resolved SocketAddress {} using for Cluster node {}", (Object)socketAddress, (Object)connectionKey.nodeId);
                return socketAddress;
            }
            InetSocketAddress socketAddress = new InetSocketAddress(connectionKey.host, connectionKey.port);
            logger.debug("Resolved SocketAddress {} using for Cluster node at {}:{}", new Object[]{socketAddress, connectionKey.host, connectionKey.port});
            return socketAddress;
        };
    }

    private SocketAddress getSocketAddress(String nodeId) {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.getNodeId().equals(nodeId)) continue;
            return SocketAddressResolver.resolve(partition.getUri(), this.redisClusterClient.getResources().dnsResolver());
        }
        return null;
    }

    private boolean validateClusterNodeMembership() {
        return this.redisClusterClient.getClusterClientOptions() == null || this.redisClusterClient.getClusterClientOptions().isValidateClusterNodeMembership();
    }

    private StatefulRedisConnection<K, V> getOrCreateConnection(ConnectionKey key) {
        return this.connections.computeIfAbsent(key, this.connectionFactory);
    }

    private class ConnectionFactory
    implements Function<ConnectionKey, StatefulRedisConnection<K, V>> {
        private final RedisClusterClient redisClusterClient;
        private final RedisCodec<K, V> redisCodec;
        private final RedisChannelWriter<K, V> clusterWriter;

        public ConnectionFactory(RedisClusterClient redisClusterClient, RedisCodec<K, V> redisCodec, RedisChannelWriter<K, V> clusterWriter) {
            this.redisClusterClient = redisClusterClient;
            this.redisCodec = redisCodec;
            this.clusterWriter = clusterWriter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StatefulRedisConnection<K, V> apply(ConnectionKey key) {
            StatefulRedisConnection connection = null;
            if (key.nodeId != null) {
                if (PooledClusterConnectionProvider.this.partitions.getPartitionByNodeId(key.nodeId) == null) {
                    throw PooledClusterConnectionProvider.this.invalidConnectionPoint("node id " + key.nodeId);
                }
                connection = this.redisClusterClient.connectToNode(this.redisCodec, key.nodeId, null, PooledClusterConnectionProvider.this.getSocketAddressSupplier(key));
            }
            if (key.host != null) {
                if (PooledClusterConnectionProvider.this.validateClusterNodeMembership() && PooledClusterConnectionProvider.this.getPartition(key.host, key.port) == null) {
                    throw PooledClusterConnectionProvider.this.invalidConnectionPoint(key.host + ":" + key.port);
                }
                connection = this.redisClusterClient.connectToNode(this.redisCodec, key.host + ":" + key.port, this.clusterWriter, PooledClusterConnectionProvider.this.getSocketAddressSupplier(key));
            }
            LettuceAssert.notNull(connection, "Connection is null. Check ConnectionKey because host and nodeId are null");
            try {
                if (key.intent == ClusterConnectionProvider.Intent.READ) {
                    connection.sync().readOnly();
                }
                Object object = PooledClusterConnectionProvider.this.stateLock;
                synchronized (object) {
                    connection.setAutoFlushCommands(PooledClusterConnectionProvider.this.autoFlushCommands);
                }
            }
            catch (RuntimeException e) {
                connection.close();
                throw e;
            }
            return connection;
        }
    }

    private static class ConnectionKey {
        private final ClusterConnectionProvider.Intent intent;
        private final String nodeId;
        private final String host;
        private final int port;

        public ConnectionKey(ClusterConnectionProvider.Intent intent, String nodeId) {
            this.intent = intent;
            this.nodeId = nodeId;
            this.host = null;
            this.port = 0;
        }

        public ConnectionKey(ClusterConnectionProvider.Intent intent, String host, int port) {
            this.intent = intent;
            this.host = host;
            this.port = port;
            this.nodeId = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConnectionKey)) {
                return false;
            }
            ConnectionKey key = (ConnectionKey)o;
            if (this.port != key.port) {
                return false;
            }
            if (this.intent != key.intent) {
                return false;
            }
            if (this.nodeId != null ? !this.nodeId.equals(key.nodeId) : key.nodeId != null) {
                return false;
            }
            return !(this.host == null ? key.host != null : !this.host.equals(key.host));
        }

        public int hashCode() {
            int result = this.intent != null ? this.intent.name().hashCode() : 0;
            result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
            result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
            result = 31 * result + this.port;
            return result;
        }
    }
}

