/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.resource;

import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.resource.DnsResolver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public class SocketAddressResolver {
    public static SocketAddress resolve(RedisURI redisURI, DnsResolver dnsResolver) {
        if (redisURI.getSocket() != null) {
            return redisURI.getResolvedAddress();
        }
        try {
            InetAddress inetAddress = dnsResolver.resolve(redisURI.getHost())[0];
            return new InetSocketAddress(inetAddress, redisURI.getPort());
        }
        catch (UnknownHostException e) {
            return redisURI.getResolvedAddress();
        }
    }
}

