/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.ReadFrom;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.AsyncClusterConnectionProvider;
import com.lambdaworks.redis.cluster.ClusterClientOptions;
import com.lambdaworks.redis.cluster.ClusterCommand;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.ClusterEventListener;
import com.lambdaworks.redis.cluster.ReadOnlyCommands;
import com.lambdaworks.redis.cluster.SlotHash;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.internal.HostAndPort;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import com.lambdaworks.redis.protocol.RedisCommand;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;

class ClusterDistributionChannelWriter<K, V>
implements RedisChannelWriter<K, V> {
    private final RedisChannelWriter<K, V> defaultWriter;
    private final ClusterEventListener clusterEventListener;
    private final int executionLimit;
    private ClusterConnectionProvider clusterConnectionProvider;
    private AsyncClusterConnectionProvider asyncClusterConnectionProvider;
    private boolean closed = false;
    private volatile Partitions partitions;

    ClusterDistributionChannelWriter(ClientOptions clientOptions, RedisChannelWriter<K, V> defaultWriter, ClusterEventListener clusterEventListener) {
        this.executionLimit = clientOptions instanceof ClusterClientOptions ? ((ClusterClientOptions)clientOptions).getMaxRedirects() : 5;
        this.defaultWriter = defaultWriter;
        this.clusterEventListener = clusterEventListener;
    }

    @Override
    public <T, C extends RedisCommand<K, V, T>> C write(C command) {
        ByteBuffer encodedKey;
        ClusterCommand clusterCommand;
        LettuceAssert.notNull(command, "Command must not be null");
        if (this.closed) {
            throw new RedisException("Connection is closed");
        }
        if (command instanceof ClusterCommand && !command.isDone() && ((clusterCommand = (ClusterCommand)command).isMoved() || clusterCommand.isAsk())) {
            boolean asking;
            HostAndPort target;
            if (clusterCommand.isMoved()) {
                target = ClusterDistributionChannelWriter.getMoveTarget(clusterCommand.getError());
                this.clusterEventListener.onMovedRedirection();
                asking = false;
            } else {
                target = ClusterDistributionChannelWriter.getAskTarget(clusterCommand.getError());
                asking = true;
                this.clusterEventListener.onAskRedirection();
            }
            command.getOutput().setError((String)null);
            CompletableFuture connectFuture = this.asyncClusterConnectionProvider.getConnectionAsync(ClusterConnectionProvider.Intent.WRITE, target.getHostText(), target.getPort());
            if (ClusterDistributionChannelWriter.isSuccessfullyCompleted(connectFuture)) {
                ClusterDistributionChannelWriter.writeCommand(command, asking, connectFuture.join(), null);
            } else {
                connectFuture.whenComplete((connection, throwable) -> ClusterDistributionChannelWriter.writeCommand(command, asking, connection, throwable));
            }
            return command;
        }
        ClusterCommand commandToSend = this.getCommandToSend(command);
        CommandArgs<K, V> args = command.getArgs();
        if (args != null && !CommandType.CLIENT.equals(commandToSend.getType()) && (encodedKey = args.getFirstEncodedKey()) != null) {
            int hash = SlotHash.getSlot(encodedKey);
            ClusterConnectionProvider.Intent intent = this.getIntent(command.getType());
            CompletableFuture connectFuture = ((AsyncClusterConnectionProvider)((Object)this.clusterConnectionProvider)).getConnectionAsync(intent, hash);
            if (ClusterDistributionChannelWriter.isSuccessfullyCompleted(connectFuture)) {
                ClusterDistributionChannelWriter.writeCommand(commandToSend, false, connectFuture.join(), null);
            } else {
                connectFuture.whenComplete((connection, throwable) -> ClusterDistributionChannelWriter.writeCommand(commandToSend, false, connection, throwable));
            }
            return (C)commandToSend;
        }
        ClusterDistributionChannelWriter.writeCommand(commandToSend, this.defaultWriter);
        return (C)commandToSend;
    }

    private static boolean isSuccessfullyCompleted(CompletableFuture<?> connectFuture) {
        return connectFuture.isDone() && !connectFuture.isCompletedExceptionally();
    }

    private ClusterCommand<K, V, ?> getCommandToSend(RedisCommand<K, V, ?> command) {
        if (command instanceof ClusterCommand) {
            return (ClusterCommand)command;
        }
        return new ClusterCommand(command, this, this.executionLimit);
    }

    private static <K, V> void writeCommand(RedisCommand<K, V, ?> command, boolean asking, StatefulRedisConnection<K, V> connection, Throwable throwable) {
        if (throwable != null) {
            command.completeExceptionally(throwable);
            return;
        }
        try {
            if (asking) {
                connection.async().asking();
            }
            ClusterDistributionChannelWriter.writeCommand(command, ((RedisChannelHandler)((Object)connection)).getChannelWriter());
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    private static <K, V> void writeCommand(RedisCommand<K, V, ?> command, RedisChannelWriter<K, V> writer) {
        try {
            ClusterDistributionChannelWriter.getWriterToUse(writer).write(command);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    private static <K, V> RedisChannelWriter<K, V> getWriterToUse(RedisChannelWriter<K, V> writer) {
        RedisChannelWriter<K, V> writerToUse = writer;
        if (writer instanceof ClusterDistributionChannelWriter) {
            writerToUse = ((ClusterDistributionChannelWriter)writer).defaultWriter;
        }
        return writerToUse;
    }

    private ClusterConnectionProvider.Intent getIntent(ProtocolKeyword type) {
        if (ReadOnlyCommands.isReadOnlyCommand(type)) {
            return ClusterConnectionProvider.Intent.READ;
        }
        return ClusterConnectionProvider.Intent.WRITE;
    }

    static HostAndPort getMoveTarget(String errorMessage) {
        LettuceAssert.notEmpty(errorMessage, "ErrorMessage must not be empty");
        LettuceAssert.isTrue(errorMessage.startsWith(CommandKeyword.MOVED.name()), "ErrorMessage must start with " + CommandKeyword.MOVED);
        String[] movedMessageParts = errorMessage.split(" ");
        LettuceAssert.isTrue(movedMessageParts.length >= 3, "ErrorMessage must consist of 3 tokens (" + errorMessage + ")");
        return HostAndPort.parseCompat(movedMessageParts[2]);
    }

    static HostAndPort getAskTarget(String errorMessage) {
        LettuceAssert.notEmpty(errorMessage, "ErrorMessage must not be empty");
        LettuceAssert.isTrue(errorMessage.startsWith(CommandKeyword.ASK.name()), "ErrorMessage must start with " + CommandKeyword.ASK);
        String[] movedMessageParts = errorMessage.split(" ");
        LettuceAssert.isTrue(movedMessageParts.length >= 3, "ErrorMessage must consist of 3 tokens (" + errorMessage + ")");
        return HostAndPort.parseCompat(movedMessageParts[2]);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.defaultWriter != null) {
            this.defaultWriter.close();
        }
        if (this.clusterConnectionProvider != null) {
            this.clusterConnectionProvider.close();
            this.clusterConnectionProvider = null;
        }
    }

    @Override
    public void setRedisChannelHandler(RedisChannelHandler<K, V> redisChannelHandler) {
        this.defaultWriter.setRedisChannelHandler(redisChannelHandler);
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.getClusterConnectionProvider().setAutoFlushCommands(autoFlush);
    }

    @Override
    public void flushCommands() {
        this.getClusterConnectionProvider().flushCommands();
    }

    public ClusterConnectionProvider getClusterConnectionProvider() {
        return this.clusterConnectionProvider;
    }

    @Override
    public void reset() {
        this.defaultWriter.reset();
        this.clusterConnectionProvider.reset();
    }

    public void setClusterConnectionProvider(ClusterConnectionProvider clusterConnectionProvider) {
        this.clusterConnectionProvider = clusterConnectionProvider;
        this.asyncClusterConnectionProvider = (AsyncClusterConnectionProvider)((Object)clusterConnectionProvider);
    }

    public void setPartitions(Partitions partitions) {
        this.partitions = partitions;
        if (this.clusterConnectionProvider != null) {
            this.clusterConnectionProvider.setPartitions(partitions);
        }
    }

    public Partitions getPartitions() {
        return this.partitions;
    }

    public void setReadFrom(ReadFrom readFrom) {
        this.clusterConnectionProvider.setReadFrom(readFrom);
    }

    public ReadFrom getReadFrom() {
        return this.clusterConnectionProvider.getReadFrom();
    }
}

