/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.LettuceFutures;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.AbstractNodeSelection;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.DynamicNodeSelection;
import com.lambdaworks.redis.cluster.NodeSelectionInvocationHandler;
import com.lambdaworks.redis.cluster.StatefulRedisClusterConnectionImpl;
import com.lambdaworks.redis.cluster.StatefulRedisClusterPubSubConnectionImpl;
import com.lambdaworks.redis.cluster.StaticNodeSelection;
import com.lambdaworks.redis.cluster.api.NodeSelectionSupport;
import com.lambdaworks.redis.cluster.api.StatefulRedisClusterConnection;
import com.lambdaworks.redis.cluster.api.sync.RedisClusterCommands;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.internal.AbstractInvocationHandler;
import com.lambdaworks.redis.internal.DefaultMethods;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

class ClusterFutureSyncInvocationHandler<K, V>
extends AbstractInvocationHandler {
    private final StatefulConnection<K, V> connection;
    private final Class<?> asyncCommandsInterface;
    private final Class<?> nodeSelectionInterface;
    private final Class<?> nodeSelectionCommandsInterface;
    private final Object asyncApi;
    private final Map<Method, Method> apiMethodCache = new ConcurrentHashMap<Method, Method>(RedisClusterCommands.class.getMethods().length, 1.0f);
    private final Map<Method, Method> connectionMethodCache = new ConcurrentHashMap<Method, Method>(5, 1.0f);
    private final Map<Method, MethodHandle> methodHandleCache = new ConcurrentHashMap<Method, MethodHandle>(5, 1.0f);

    ClusterFutureSyncInvocationHandler(StatefulConnection<K, V> connection, Class<?> asyncCommandsInterface, Class<?> nodeSelectionInterface, Class<?> nodeSelectionCommandsInterface, Object asyncApi) {
        this.connection = connection;
        this.asyncCommandsInterface = asyncCommandsInterface;
        this.nodeSelectionInterface = nodeSelectionInterface;
        this.nodeSelectionCommandsInterface = nodeSelectionCommandsInterface;
        this.asyncApi = asyncApi;
    }

    @Override
    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.isDefault()) {
                return this.methodHandleCache.computeIfAbsent(method, ClusterFutureSyncInvocationHandler::lookupDefaultMethod).bindTo(proxy).invokeWithArguments(args);
            }
            if (method.getName().equals("getConnection") && args.length > 0) {
                return this.getConnection(method, args);
            }
            if (method.getName().equals("readonly") && args.length == 1) {
                return this.nodes((Predicate)args[0], ClusterConnectionProvider.Intent.READ, false);
            }
            if (method.getName().equals("nodes") && args.length == 1) {
                return this.nodes((Predicate)args[0], ClusterConnectionProvider.Intent.WRITE, false);
            }
            if (method.getName().equals("nodes") && args.length == 2) {
                return this.nodes((Predicate)args[0], ClusterConnectionProvider.Intent.WRITE, (Boolean)args[1]);
            }
            Method targetMethod = this.apiMethodCache.computeIfAbsent(method, key -> {
                try {
                    return this.asyncApi.getClass().getMethod(key.getName(), key.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException(e);
                }
            });
            Object result = targetMethod.invoke(this.asyncApi, args);
            if (result instanceof RedisFuture) {
                RedisFuture command = (RedisFuture)result;
                if (!method.getName().equals("exec") && !method.getName().equals("multi") && this.connection instanceof StatefulRedisConnection && ((StatefulRedisConnection)this.connection).isMulti()) {
                    return null;
                }
                return LettuceFutures.awaitOrCancel(command, this.connection.getTimeout(), this.connection.getTimeoutUnit());
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private Object getConnection(Method method, Object[] args) throws Exception {
        Method targetMethod = this.connectionMethodCache.computeIfAbsent(method, this::lookupMethod);
        Object result = targetMethod.invoke(this.connection, args);
        if (result instanceof StatefulRedisClusterConnection) {
            StatefulRedisClusterConnection connection = (StatefulRedisClusterConnection)result;
            return connection.sync();
        }
        if (result instanceof StatefulRedisConnection) {
            StatefulRedisConnection connection = (StatefulRedisConnection)result;
            return connection.sync();
        }
        throw new IllegalArgumentException("Cannot call method " + method);
    }

    private Method lookupMethod(Method key) {
        try {
            return this.connection.getClass().getMethod(key.getName(), key.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected Object nodes(Predicate<RedisClusterNode> predicate, ClusterConnectionProvider.Intent intent, boolean dynamic) {
        RedisChannelHandler impl;
        AbstractNodeSelection selection = null;
        if (this.connection instanceof StatefulRedisClusterConnectionImpl) {
            impl = (StatefulRedisClusterConnectionImpl)this.connection;
            selection = dynamic ? new DynamicNodeSelection(((StatefulRedisClusterConnectionImpl)impl).getClusterDistributionChannelWriter(), predicate, intent, StatefulRedisConnection::sync) : new StaticNodeSelection(((StatefulRedisClusterConnectionImpl)impl).getClusterDistributionChannelWriter(), predicate, intent, StatefulRedisConnection::sync);
        }
        if (this.connection instanceof StatefulRedisClusterPubSubConnectionImpl) {
            impl = (StatefulRedisClusterPubSubConnectionImpl)this.connection;
            selection = new StaticNodeSelection(((StatefulRedisClusterPubSubConnectionImpl)impl).getClusterDistributionChannelWriter(), predicate, intent, StatefulRedisConnection::sync);
        }
        NodeSelectionInvocationHandler h = new NodeSelectionInvocationHandler(selection, this.asyncCommandsInterface, this.connection.getTimeout(), this.connection.getTimeoutUnit());
        return Proxy.newProxyInstance(NodeSelectionSupport.class.getClassLoader(), new Class[]{this.nodeSelectionCommandsInterface, this.nodeSelectionInterface}, (InvocationHandler)h);
    }

    private static MethodHandle lookupDefaultMethod(Method method) {
        try {
            return DefaultMethods.lookupMethodHandle(method);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

