/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.internal.LettuceSets;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.protocol.ConnectionWatchdog;
import com.lambdaworks.redis.protocol.RedisCommand;
import com.lambdaworks.redis.resource.ClientResources;
import io.netty.channel.ChannelHandler;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.Set;

@ChannelHandler.Sharable
class ClusterNodeCommandHandler<K, V>
extends CommandHandler<K, V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ClusterNodeCommandHandler.class);
    private static final Set<CommandHandler.LifecycleState> CHANNEL_OPEN_STATES = LettuceSets.unmodifiableSet(CommandHandler.LifecycleState.ACTIVATING, CommandHandler.LifecycleState.ACTIVE, CommandHandler.LifecycleState.CONNECTED);
    private final RedisChannelWriter<K, V> clusterChannelWriter;

    public ClusterNodeCommandHandler(ClientOptions clientOptions, ClientResources clientResources, RedisChannelWriter<K, V> clusterChannelWriter) {
        super(clientOptions, clientResources);
        this.clusterChannelWriter = clusterChannelWriter;
    }

    public void prepareClose() {
        ConnectionWatchdog connectionWatchdog;
        if (this.channel != null && (connectionWatchdog = (ConnectionWatchdog)this.channel.pipeline().get(ConnectionWatchdog.class)) != null) {
            connectionWatchdog.setReconnectSuspended(true);
        }
    }

    @Override
    public void close() {
        logger.debug("{} close()", (Object)this.logPrefix());
        if (this.clusterChannelWriter != null) {
            ArrayList commands = new ArrayList();
            if (this.isAutoReconnect() && !CHANNEL_OPEN_STATES.contains((Object)this.getState())) {
                commands.addAll(this.shiftCommands(this.stack));
            }
            commands.addAll(this.shiftCommands(this.disconnectedBuffer));
            commands.addAll(this.shiftCommands(this.commandBuffer));
            this.retriggerCommands(commands);
        }
        super.close();
    }

    protected void retriggerCommands(Collection<RedisCommand<K, V, ?>> commands) {
        for (RedisCommand<K, V, ?> queuedCommand : commands) {
            if (queuedCommand == null || queuedCommand.isCancelled()) continue;
            try {
                this.clusterChannelWriter.write(queuedCommand);
            }
            catch (RedisException e) {
                queuedCommand.completeExceptionally(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<RedisCommand<K, V, ?>> shiftCommands(Queue<RedisCommand<K, V, ?>> source) {
        Object object = this.stateLock;
        synchronized (object) {
            List<RedisCommand<K, V, ?>> list;
            try {
                this.lockWritersExclusive();
                list = ClusterNodeCommandHandler.drainCommands(source);
            }
            catch (Throwable throwable) {
                this.unlockWritersExclusive();
                throw throwable;
            }
            this.unlockWritersExclusive();
            return list;
        }
    }

    public boolean isAutoReconnect() {
        return this.clientOptions.isAutoReconnect();
    }
}

