/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.pubsub;

import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.protocol.RedisCommand;
import com.lambdaworks.redis.pubsub.PubSubOutput;
import com.lambdaworks.redis.resource.ClientResources;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public class PubSubCommandHandler<K, V>
extends CommandHandler<K, V> {
    private final RedisCodec<K, V> codec;
    private PubSubOutput<K, V, V> output;

    public PubSubCommandHandler(ClientOptions clientOptions, ClientResources clientResources, RedisCodec<K, V> codec) {
        super(clientOptions, clientResources);
        this.codec = codec;
        this.output = new PubSubOutput(codec);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer) {
        super.decode(ctx, buffer);
        while (buffer.isReadable()) {
            if (!this.rsm.decode(buffer, this.output)) {
                return;
            }
            ctx.fireChannelRead(this.output);
            this.output = new PubSubOutput(this.codec);
            buffer.discardReadBytes();
        }
    }

    @Override
    protected boolean canDecode(ByteBuf buffer) {
        return super.canDecode(buffer) && this.output.type() == null;
    }

    @Override
    protected void afterComplete(ChannelHandlerContext ctx, RedisCommand<K, V, ?> command) {
        if (command.getOutput() instanceof PubSubOutput) {
            ctx.fireChannelRead(command.getOutput());
        }
    }
}

