/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import java.nio.charset.StandardCharsets;

public class ScanArgs {
    private Long count;
    private String match;

    public ScanArgs match(String match) {
        LettuceAssert.notNull(match, "Match must not be null");
        this.match = match;
        return this;
    }

    public ScanArgs limit(long count) {
        this.count = count;
        return this;
    }

    <K, V> void build(CommandArgs<K, V> args) {
        if (this.match != null) {
            args.add(CommandKeyword.MATCH).add(this.match.getBytes(StandardCharsets.UTF_8));
        }
        if (this.count != null) {
            args.add(CommandKeyword.COUNT).add(this.count);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static ScanArgs limit(long count) {
            return new ScanArgs().limit(count);
        }

        public static ScanArgs matches(String matches) {
            return new ScanArgs().match(matches);
        }
    }
}

