/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.cluster.ClusterClientOptions;
import com.lambdaworks.redis.cluster.ClusterEventListener;
import com.lambdaworks.redis.cluster.ClusterTopologyRefreshOptions;
import com.lambdaworks.redis.cluster.RedisClusterClient;
import com.lambdaworks.redis.resource.ClientResources;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

class ClusterTopologyRefreshScheduler
implements Runnable,
ClusterEventListener {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ClusterTopologyRefreshScheduler.class);
    private static final ClusterTopologyRefreshOptions FALLBACK_OPTIONS = ClusterTopologyRefreshOptions.create();
    private final RedisClusterClient redisClusterClient;
    private final ClientResources clientResources;
    private final ClusterTopologyRefreshTask clusterTopologyRefreshTask;
    private final AtomicReference<Timeout> timeoutRef = new AtomicReference();

    ClusterTopologyRefreshScheduler(RedisClusterClient redisClusterClient, ClientResources clientResources) {
        this.redisClusterClient = redisClusterClient;
        this.clientResources = clientResources;
        this.clusterTopologyRefreshTask = new ClusterTopologyRefreshTask(redisClusterClient);
    }

    @Override
    public void run() {
        logger.debug("ClusterTopologyRefreshScheduler.run()");
        if (this.isEventLoopActive() && this.redisClusterClient.getClusterClientOptions() != null) {
            if (!this.redisClusterClient.getClusterClientOptions().isRefreshClusterView()) {
                logger.debug("Periodic ClusterTopologyRefresh is disabled");
                return;
            }
        } else {
            logger.debug("Periodic ClusterTopologyRefresh is disabled");
            return;
        }
        this.clientResources.eventExecutorGroup().submit((Runnable)this.clusterTopologyRefreshTask);
    }

    private void indicateTopologyRefreshSignal() {
        logger.debug("ClusterTopologyRefreshScheduler.indicateTopologyRefreshSignal()");
        if (!this.acquireTimeout()) {
            return;
        }
        if (this.isEventLoopActive() && this.redisClusterClient.getClusterClientOptions() != null) {
            this.clientResources.eventExecutorGroup().submit((Runnable)this.clusterTopologyRefreshTask);
        } else {
            logger.debug("Adaptive ClusterTopologyRefresh is disabled");
        }
    }

    protected boolean isEventLoopActive() {
        EventExecutorGroup eventExecutors = this.clientResources.eventExecutorGroup();
        return !eventExecutors.isShuttingDown() && !eventExecutors.isShutdown() && !eventExecutors.isTerminated();
    }

    private boolean acquireTimeout() {
        Timeout existingTimeout = this.timeoutRef.get();
        if (existingTimeout != null && !existingTimeout.isExpired()) {
            return false;
        }
        ClusterTopologyRefreshOptions refreshOptions = this.getClusterTopologyRefreshOptions();
        Timeout timeout = new Timeout(refreshOptions.getAdaptiveRefreshTimeout(), refreshOptions.getAdaptiveRefreshTimeoutUnit());
        return this.timeoutRef.compareAndSet(existingTimeout, timeout);
    }

    @Override
    public void onAskRedirection() {
        if (this.isEnabled(ClusterTopologyRefreshOptions.RefreshTrigger.ASK_REDIRECT)) {
            this.indicateTopologyRefreshSignal();
        }
    }

    @Override
    public void onMovedRedirection() {
        if (this.isEnabled(ClusterTopologyRefreshOptions.RefreshTrigger.MOVED_REDIRECT)) {
            this.indicateTopologyRefreshSignal();
        }
    }

    @Override
    public void onReconnectAttempt(int attempt) {
        if (this.isEnabled(ClusterTopologyRefreshOptions.RefreshTrigger.PERSISTENT_RECONNECTS) && attempt >= this.getClusterTopologyRefreshOptions().getRefreshTriggersReconnectAttempts()) {
            this.indicateTopologyRefreshSignal();
        }
    }

    @Override
    public void onUnknownNode() {
        if (this.isEnabled(ClusterTopologyRefreshOptions.RefreshTrigger.UNKNOWN_NODE)) {
            this.indicateTopologyRefreshSignal();
        }
    }

    private ClusterTopologyRefreshOptions getClusterTopologyRefreshOptions() {
        ClusterClientOptions clusterClientOptions = this.redisClusterClient.getClusterClientOptions();
        if (clusterClientOptions != null) {
            return clusterClientOptions.getTopologyRefreshOptions();
        }
        return FALLBACK_OPTIONS;
    }

    private boolean isEnabled(ClusterTopologyRefreshOptions.RefreshTrigger refreshTrigger) {
        return this.getClusterTopologyRefreshOptions().getAdaptiveRefreshTriggers().contains((Object)refreshTrigger);
    }

    private static class ClusterTopologyRefreshTask
    implements Runnable {
        private final RedisClusterClient redisClusterClient;

        public ClusterTopologyRefreshTask(RedisClusterClient redisClusterClient) {
            this.redisClusterClient = redisClusterClient;
        }

        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug("ClusterTopologyRefreshTask requesting partitions from {}", this.redisClusterClient.getTopologyRefreshSource());
            }
            try {
                this.redisClusterClient.reloadPartitions();
            }
            catch (Exception e) {
                logger.warn("Cannot refresh Redis Cluster topology", (Throwable)e);
            }
        }
    }

    private class Timeout {
        private final long expiresMs;

        public Timeout(long timeout, TimeUnit timeUnit) {
            this.expiresMs = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        }

        public boolean isExpired() {
            return this.expiresMs < System.currentTimeMillis();
        }

        public long remaining() {
            long diff = this.expiresMs - System.currentTimeMillis();
            if (diff > 0L) {
                return diff;
            }
            return 0L;
        }
    }
}

