/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.ConnectionBuilder;
import com.lambdaworks.redis.ConnectionFuture;
import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.ReadFrom;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisConnectionException;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.SslConnectionBuilder;
import com.lambdaworks.redis.StatefulRedisConnectionImpl;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.ClusterClientOptions;
import com.lambdaworks.redis.cluster.ClusterDistributionChannelWriter;
import com.lambdaworks.redis.cluster.ClusterNodeCommandHandler;
import com.lambdaworks.redis.cluster.ClusterPubSubConnectionProvider;
import com.lambdaworks.redis.cluster.ClusterTopologyRefreshOptions;
import com.lambdaworks.redis.cluster.ClusterTopologyRefreshScheduler;
import com.lambdaworks.redis.cluster.PartitionsConsensus;
import com.lambdaworks.redis.cluster.PooledClusterConnectionProvider;
import com.lambdaworks.redis.cluster.ReconnectEventListener;
import com.lambdaworks.redis.cluster.RedisClusterURIUtil;
import com.lambdaworks.redis.cluster.RoundRobinSocketAddressSupplier;
import com.lambdaworks.redis.cluster.StatefulRedisClusterConnectionImpl;
import com.lambdaworks.redis.cluster.StatefulRedisClusterPubSubConnectionImpl;
import com.lambdaworks.redis.cluster.api.StatefulRedisClusterConnection;
import com.lambdaworks.redis.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import com.lambdaworks.redis.cluster.api.sync.RedisAdvancedClusterCommands;
import com.lambdaworks.redis.cluster.event.ClusterTopologyChangedEvent;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.cluster.pubsub.StatefulRedisClusterPubSubConnection;
import com.lambdaworks.redis.cluster.topology.ClusterTopologyRefresh;
import com.lambdaworks.redis.cluster.topology.NodeConnectionFactory;
import com.lambdaworks.redis.cluster.topology.TopologyComparators;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.StringCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.internal.LettuceLists;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.pubsub.PubSubCommandHandler;
import com.lambdaworks.redis.pubsub.StatefulRedisPubSubConnection;
import com.lambdaworks.redis.pubsub.StatefulRedisPubSubConnectionImpl;
import com.lambdaworks.redis.resource.ClientResources;
import com.lambdaworks.redis.resource.SocketAddressResolver;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class RedisClusterClient
extends AbstractRedisClient {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisClusterClient.class);
    protected final AtomicBoolean clusterTopologyRefreshActivated = new AtomicBoolean(false);
    protected final AtomicReference<ScheduledFuture<?>> clusterTopologyRefreshFuture = new AtomicReference();
    private final ClusterTopologyRefresh refresh = new ClusterTopologyRefresh(new NodeConnectionFactoryImpl(), this.getResources());
    private final ClusterTopologyRefreshScheduler clusterTopologyRefreshScheduler = new ClusterTopologyRefreshScheduler(this, this.getResources());
    private final Iterable<RedisURI> initialUris;
    private Partitions partitions;

    protected RedisClusterClient() {
        this.setOptions(ClusterClientOptions.create());
        this.initialUris = Collections.emptyList();
    }

    @Deprecated
    public RedisClusterClient(RedisURI initialUri) {
        this(Collections.singletonList(RedisClusterClient.assertNotNull(initialUri)));
    }

    @Deprecated
    public RedisClusterClient(List<RedisURI> redisURIs) {
        this(null, redisURIs);
    }

    protected RedisClusterClient(ClientResources clientResources, Iterable<RedisURI> redisURIs) {
        super(clientResources);
        RedisClusterClient.assertNotEmpty(redisURIs);
        RedisClusterClient.assertSameOptions(redisURIs);
        this.initialUris = Collections.unmodifiableList(LettuceLists.newList(redisURIs));
        this.setDefaultTimeout(this.getFirstUri().getTimeout(), this.getFirstUri().getUnit());
        this.setOptions(ClusterClientOptions.builder().build());
    }

    private static void assertSameOptions(Iterable<RedisURI> redisURIs) {
        Boolean ssl = null;
        Boolean startTls = null;
        Boolean verifyPeer = null;
        for (RedisURI redisURI : redisURIs) {
            if (ssl == null) {
                ssl = redisURI.isSsl();
            }
            if (startTls == null) {
                startTls = redisURI.isStartTls();
            }
            if (verifyPeer == null) {
                verifyPeer = redisURI.isVerifyPeer();
            }
            if (ssl.booleanValue() != redisURI.isSsl()) {
                throw new IllegalArgumentException("RedisURI " + redisURI + " SSL is not consistent with the other seed URI SSL settings");
            }
            if (startTls.booleanValue() != redisURI.isStartTls()) {
                throw new IllegalArgumentException("RedisURI " + redisURI + " StartTLS is not consistent with the other seed URI StartTLS settings");
            }
            if (verifyPeer.booleanValue() == redisURI.isVerifyPeer()) continue;
            throw new IllegalArgumentException("RedisURI " + redisURI + " VerifyPeer is not consistent with the other seed URI VerifyPeer settings");
        }
    }

    public static RedisClusterClient create(RedisURI redisURI) {
        RedisClusterClient.assertNotNull(redisURI);
        return RedisClusterClient.create(Collections.singleton(redisURI));
    }

    public static RedisClusterClient create(Iterable<RedisURI> redisURIs) {
        RedisClusterClient.assertNotEmpty(redisURIs);
        RedisClusterClient.assertSameOptions(redisURIs);
        return new RedisClusterClient(null, redisURIs);
    }

    public static RedisClusterClient create(String uri) {
        LettuceAssert.notEmpty(uri, "URI must not be empty");
        return RedisClusterClient.create(RedisClusterURIUtil.toRedisURIs(URI.create(uri)));
    }

    public static RedisClusterClient create(ClientResources clientResources, RedisURI redisURI) {
        RedisClusterClient.assertNotNull(clientResources);
        RedisClusterClient.assertNotNull(redisURI);
        return RedisClusterClient.create(clientResources, Collections.singleton(redisURI));
    }

    public static RedisClusterClient create(ClientResources clientResources, String uri) {
        RedisClusterClient.assertNotNull(clientResources);
        LettuceAssert.notEmpty(uri, "URI must not be empty");
        return RedisClusterClient.create(clientResources, RedisClusterURIUtil.toRedisURIs(URI.create(uri)));
    }

    public static RedisClusterClient create(ClientResources clientResources, Iterable<RedisURI> redisURIs) {
        RedisClusterClient.assertNotNull(clientResources);
        RedisClusterClient.assertNotEmpty(redisURIs);
        RedisClusterClient.assertSameOptions(redisURIs);
        return new RedisClusterClient(clientResources, redisURIs);
    }

    public StatefulRedisClusterConnection<String, String> connect() {
        return this.connect(this.newStringStringCodec());
    }

    public <K, V> StatefulRedisClusterConnection<K, V> connect(RedisCodec<K, V> codec) {
        return this.connectClusterImpl(codec);
    }

    public StatefulRedisClusterPubSubConnection<String, String> connectPubSub() {
        return this.connectPubSub(this.newStringStringCodec());
    }

    public <K, V> StatefulRedisClusterPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec) {
        return this.connectClusterPubSubImpl(codec);
    }

    @Deprecated
    public RedisAdvancedClusterCommands<String, String> connectCluster() {
        return this.connectCluster(this.newStringStringCodec());
    }

    @Deprecated
    public <K, V> RedisAdvancedClusterCommands<K, V> connectCluster(RedisCodec<K, V> codec) {
        return this.connectClusterImpl(codec).sync();
    }

    @Deprecated
    public RedisAdvancedClusterAsyncCommands<String, String> connectClusterAsync() {
        return this.connectClusterImpl(this.newStringStringCodec()).async();
    }

    @Deprecated
    public <K, V> RedisAdvancedClusterAsyncCommands<K, V> connectClusterAsync(RedisCodec<K, V> codec) {
        return this.connectClusterImpl(codec).async();
    }

    protected StatefulRedisConnection<String, String> connectToNode(SocketAddress socketAddress) {
        return this.connectToNode(this.newStringStringCodec(), socketAddress.toString(), null, () -> socketAddress);
    }

    <K, V> StatefulRedisConnection<K, V> connectToNode(RedisCodec<K, V> codec, String nodeId, RedisChannelWriter<K, V> clusterWriter, Supplier<SocketAddress> socketAddressSupplier) {
        return this.getConnection(this.connectToNodeAsync(codec, nodeId, clusterWriter, socketAddressSupplier));
    }

    <K, V> ConnectionFuture<StatefulRedisConnection<K, V>> connectToNodeAsync(RedisCodec<K, V> codec, String nodeId, RedisChannelWriter<K, V> clusterWriter, Supplier<SocketAddress> socketAddressSupplier) {
        RedisClusterClient.assertNotNull(codec);
        RedisClusterClient.assertNotEmpty(this.initialUris);
        LettuceAssert.notNull(socketAddressSupplier, "SocketAddressSupplier must not be null");
        SocketAddress socketAddress = socketAddressSupplier.get();
        logger.debug(String.format("connectToNodeAsync(%s at %s)", nodeId, socketAddress));
        ClusterNodeCommandHandler<K, V> handler = new ClusterNodeCommandHandler<K, V>(this.clientOptions, this.getResources(), clusterWriter);
        StatefulRedisConnectionImpl connection = new StatefulRedisConnectionImpl(handler, codec, this.timeout, this.unit);
        ConnectionFuture connectionFuture = this.connectStatefulAsync(handler, connection, this.getFirstUri(), socketAddressSupplier);
        return connectionFuture.whenComplete((conn, throwable) -> {
            if (throwable != null) {
                connection.close();
            }
        });
    }

    <K, V> StatefulRedisPubSubConnection<K, V> connectPubSubToNode(RedisCodec<K, V> codec, String nodeId, Supplier<SocketAddress> socketAddressSupplier) {
        return this.getConnection(this.connectPubSubToNodeAsync(codec, nodeId, socketAddressSupplier));
    }

    <K, V> ConnectionFuture<StatefulRedisPubSubConnection<K, V>> connectPubSubToNodeAsync(RedisCodec<K, V> codec, String nodeId, Supplier<SocketAddress> socketAddressSupplier) {
        RedisClusterClient.assertNotNull(codec);
        RedisClusterClient.assertNotEmpty(this.initialUris);
        LettuceAssert.notNull(socketAddressSupplier, "SocketAddressSupplier must not be null");
        logger.debug("connectPubSubToNode(" + nodeId + ")");
        PubSubCommandHandler<K, V> handler = new PubSubCommandHandler<K, V>(this.clientOptions, this.clientResources, codec);
        StatefulRedisPubSubConnectionImpl connection = new StatefulRedisPubSubConnectionImpl(handler, codec, this.timeout, this.unit);
        ConnectionFuture connectionFuture = this.connectStatefulAsync(handler, connection, this.getFirstUri(), socketAddressSupplier);
        return connectionFuture.whenComplete((conn, throwable) -> {
            if (throwable != null) {
                connection.close();
            }
        });
    }

    <K, V> StatefulRedisClusterConnectionImpl<K, V> connectClusterImpl(RedisCodec<K, V> codec) {
        if (this.partitions == null) {
            this.initializePartitions();
        }
        this.activateTopologyRefreshIfNeeded();
        logger.debug("connectCluster(" + this.initialUris + ")");
        Supplier<SocketAddress> socketAddressSupplier = this.getSocketAddressSupplier(TopologyComparators::sortByClientCount);
        CommandHandler handler = new CommandHandler(this.clientOptions, this.clientResources);
        ClusterDistributionChannelWriter clusterWriter = new ClusterDistributionChannelWriter(this.clientOptions, handler, this.clusterTopologyRefreshScheduler);
        PooledClusterConnectionProvider pooledClusterConnectionProvider = new PooledClusterConnectionProvider(this, clusterWriter, codec, this.clusterTopologyRefreshScheduler);
        clusterWriter.setClusterConnectionProvider(pooledClusterConnectionProvider);
        StatefulRedisClusterConnectionImpl connection = new StatefulRedisClusterConnectionImpl(clusterWriter, codec, this.timeout, this.unit);
        connection.setReadFrom(ReadFrom.MASTER);
        connection.setPartitions(this.partitions);
        boolean connected = false;
        RedisException causingException = null;
        int connectionAttempts = Math.max(1, this.partitions.size());
        for (int i = 0; i < connectionAttempts; ++i) {
            try {
                this.connectStateful(handler, connection, this.getFirstUri(), socketAddressSupplier);
                connection.inspectRedisState();
                connected = true;
                break;
            }
            catch (RedisException e) {
                logger.warn(e.getMessage());
                causingException = e;
                continue;
            }
        }
        if (!connected) {
            connection.close();
            if (causingException != null) {
                throw causingException;
            }
        }
        connection.registerCloseables(this.closeableResources, clusterWriter, pooledClusterConnectionProvider);
        return connection;
    }

    <K, V> StatefulRedisClusterPubSubConnection<K, V> connectClusterPubSubImpl(RedisCodec<K, V> codec) {
        if (this.partitions == null) {
            this.initializePartitions();
        }
        this.activateTopologyRefreshIfNeeded();
        logger.debug("connectClusterPubSub(" + this.initialUris + ")");
        Supplier<SocketAddress> socketAddressSupplier = this.getSocketAddressSupplier(TopologyComparators::sortByClientCount);
        PubSubCommandHandler<K, V> handler = new PubSubCommandHandler<K, V>(this.clientOptions, this.clientResources, codec);
        ClusterDistributionChannelWriter<K, V> clusterWriter = new ClusterDistributionChannelWriter<K, V>(this.clientOptions, handler, this.clusterTopologyRefreshScheduler);
        StatefulRedisClusterPubSubConnectionImpl<K, V> connection = new StatefulRedisClusterPubSubConnectionImpl<K, V>(clusterWriter, codec, this.timeout, this.unit);
        ClusterPubSubConnectionProvider<K, V> pooledClusterConnectionProvider = new ClusterPubSubConnectionProvider<K, V>(this, clusterWriter, codec, connection.getUpstreamListener(), this.clusterTopologyRefreshScheduler);
        clusterWriter.setClusterConnectionProvider(pooledClusterConnectionProvider);
        connection.setPartitions(this.partitions);
        boolean connected = false;
        RedisException causingException = null;
        int connectionAttempts = Math.max(1, this.partitions.size());
        for (int i = 0; i < connectionAttempts; ++i) {
            try {
                this.connectStateful(handler, connection, this.getFirstUri(), socketAddressSupplier);
                connection.inspectRedisState();
                connected = true;
                break;
            }
            catch (RedisException e) {
                logger.warn(e.getMessage());
                causingException = e;
                continue;
            }
        }
        if (!connected) {
            connection.close();
            if (causingException != null) {
                throw causingException;
            }
        }
        connection.registerCloseables(this.closeableResources, clusterWriter, pooledClusterConnectionProvider);
        return connection;
    }

    private <K, V> void connectStateful(CommandHandler<K, V> handler, StatefulRedisConnectionImpl<K, V> connection, RedisURI connectionSettings, Supplier<SocketAddress> socketAddressSupplier) {
        this.getConnection(this.connectStatefulAsync(handler, connection, connectionSettings, socketAddressSupplier));
    }

    private <K, V> void connectStateful(CommandHandler<K, V> handler, StatefulRedisClusterConnectionImpl<K, V> connection, RedisURI connectionSettings, Supplier<SocketAddress> socketAddressSupplier) {
        this.getConnection(this.connectStatefulAsync(handler, connection, connectionSettings, socketAddressSupplier));
    }

    private <K, V, T extends RedisChannelHandler<K, V>, S> ConnectionFuture<S> connectStatefulAsync(CommandHandler<K, V> handler, T connection, RedisURI connectionSettings, Supplier<SocketAddress> socketAddressSupplier) {
        ConnectionBuilder connectionBuilder = this.createConnectionBuilder(handler, connection, connectionSettings, socketAddressSupplier);
        if (this.clientOptions.isPingBeforeActivateConnection()) {
            if (this.hasPassword(connectionSettings)) {
                connectionBuilder.enableAuthPingBeforeConnect();
            } else {
                connectionBuilder.enablePingBeforeConnect();
            }
        }
        CompletionStage future = this.initializeChannelAsync(connectionBuilder);
        if (!this.clientOptions.isPingBeforeActivateConnection() && this.hasPassword(connectionSettings)) {
            future = future.thenApplyAsync(channelHandler -> {
                if (connection instanceof StatefulRedisClusterConnectionImpl) {
                    ((StatefulRedisClusterConnectionImpl)connection).async().auth(new String(connectionSettings.getPassword()));
                }
                if (connection instanceof StatefulRedisConnectionImpl) {
                    ((StatefulRedisConnectionImpl)connection).async().auth(new String(connectionSettings.getPassword()));
                }
                return channelHandler;
            }, (Executor)this.clientResources.eventExecutorGroup());
        }
        if (LettuceStrings.isNotEmpty(connectionSettings.getClientName())) {
            future = future.thenApply(channelHandler -> {
                if (connection instanceof StatefulRedisClusterConnectionImpl) {
                    ((StatefulRedisClusterConnectionImpl)connection).setClientName(connectionSettings.getClientName());
                }
                if (connection instanceof StatefulRedisConnectionImpl) {
                    ((StatefulRedisConnectionImpl)connection).setClientName(connectionSettings.getClientName());
                }
                return channelHandler;
            });
        }
        return future.thenApply(channelHandler -> connection);
    }

    private boolean hasPassword(RedisURI connectionSettings) {
        return connectionSettings.getPassword() != null && connectionSettings.getPassword().length != 0;
    }

    private <K, V> ConnectionBuilder createConnectionBuilder(CommandHandler<K, V> handler, RedisChannelHandler<K, V> connection, RedisURI connectionSettings, Supplier<SocketAddress> socketAddressSupplier) {
        ConnectionBuilder connectionBuilder;
        if (connectionSettings.isSsl()) {
            SslConnectionBuilder sslConnectionBuilder = SslConnectionBuilder.sslConnectionBuilder();
            sslConnectionBuilder.ssl(connectionSettings);
            connectionBuilder = sslConnectionBuilder;
        } else {
            connectionBuilder = ConnectionBuilder.connectionBuilder();
        }
        connectionBuilder.reconnectionListener(new ReconnectEventListener(this.clusterTopologyRefreshScheduler));
        connectionBuilder.clientOptions(this.clientOptions);
        connectionBuilder.clientResources(this.clientResources);
        this.connectionBuilder(handler, connection, socketAddressSupplier, connectionBuilder, connectionSettings);
        this.channelType(connectionBuilder, connectionSettings);
        return connectionBuilder;
    }

    public void reloadPartitions() {
        if (this.partitions == null) {
            this.initializePartitions();
            this.partitions.updateCache();
        } else {
            Partitions loadedPartitions = this.loadPartitions();
            if (TopologyComparators.isChanged(this.getPartitions(), loadedPartitions)) {
                logger.debug("Using a new cluster topology");
                ArrayList<RedisClusterNode> before = new ArrayList<RedisClusterNode>(this.getPartitions());
                ArrayList<RedisClusterNode> after = new ArrayList<RedisClusterNode>(loadedPartitions);
                this.getResources().eventBus().publish(new ClusterTopologyChangedEvent(before, after));
            }
            this.partitions.reload(loadedPartitions.getPartitions());
        }
        this.updatePartitionsInConnections();
    }

    protected void updatePartitionsInConnections() {
        this.forEachClusterConnection(input -> input.setPartitions(this.partitions));
        this.forEachClusterPubSubConnection(input -> input.setPartitions(this.partitions));
    }

    protected void initializePartitions() {
        this.partitions = this.loadPartitions();
    }

    public Partitions getPartitions() {
        if (this.partitions == null) {
            this.initializePartitions();
        }
        return this.partitions;
    }

    protected Partitions loadPartitions() {
        Iterable<RedisURI> topologyRefreshSource = this.getTopologyRefreshSource();
        try {
            return this.doLoadPartitions(topologyRefreshSource);
        }
        catch (RedisException e) {
            if (this.useDynamicRefreshSources() && topologyRefreshSource != this.initialUris) {
                try {
                    return this.doLoadPartitions(this.initialUris);
                }
                catch (RedisConnectionException e2) {
                    RedisException exception = new RedisException(RedisClusterClient.getTopologyRefreshErrorMessage(this.initialUris), e2);
                    exception.addSuppressed(e);
                    throw exception;
                }
            }
            if (e.getClass().equals(RedisException.class)) {
                throw e;
            }
            throw new RedisException(RedisClusterClient.getTopologyRefreshErrorMessage(topologyRefreshSource), e);
        }
    }

    private Partitions doLoadPartitions(Iterable<RedisURI> topologyRefreshSource) {
        Map<RedisURI, Partitions> partitions = this.refresh.loadViews(topologyRefreshSource, this.useDynamicRefreshSources());
        if (partitions.isEmpty()) {
            throw new RedisException(RedisClusterClient.getTopologyRefreshErrorMessage(topologyRefreshSource));
        }
        Partitions loadedPartitions = this.determinePartitions(this.partitions, partitions);
        RedisURI viewedBy = this.refresh.getViewedBy(partitions, loadedPartitions);
        for (RedisClusterNode partition : loadedPartitions) {
            if (viewedBy == null) continue;
            RedisURI uri = partition.getUri();
            RedisClusterURIUtil.applyUriConnectionSettings(viewedBy, uri);
        }
        this.activateTopologyRefreshIfNeeded();
        return loadedPartitions;
    }

    private static String getTopologyRefreshErrorMessage(Iterable<RedisURI> topologyRefreshSource) {
        return "Cannot retrieve initial cluster partitions from initial URIs " + topologyRefreshSource;
    }

    protected Partitions determinePartitions(Partitions current, Map<RedisURI, Partitions> topologyViews) {
        if (current == null) {
            return PartitionsConsensus.HEALTHY_MAJORITY.getPartitions(null, topologyViews);
        }
        return PartitionsConsensus.KNOWN_MAJORITY.getPartitions(current, topologyViews);
    }

    private void activateTopologyRefreshIfNeeded() {
        if (this.getOptions() instanceof ClusterClientOptions) {
            ClusterClientOptions options = (ClusterClientOptions)this.getOptions();
            ClusterTopologyRefreshOptions topologyRefreshOptions = options.getTopologyRefreshOptions();
            if (!topologyRefreshOptions.isPeriodicRefreshEnabled() || this.clusterTopologyRefreshActivated.get()) {
                return;
            }
            if (this.clusterTopologyRefreshActivated.compareAndSet(false, true)) {
                ScheduledFuture scheduledFuture = this.genericWorkerPool.scheduleAtFixedRate((Runnable)this.clusterTopologyRefreshScheduler, options.getRefreshPeriod(), options.getRefreshPeriod(), options.getRefreshPeriodUnit());
                this.clusterTopologyRefreshFuture.set(scheduledFuture);
            }
        }
    }

    public void setPartitions(Partitions partitions) {
        this.partitions = partitions;
    }

    public ClientResources getResources() {
        return this.clientResources;
    }

    @Override
    public void shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        if (this.clusterTopologyRefreshActivated.compareAndSet(true, false)) {
            ScheduledFuture<?> scheduledFuture = this.clusterTopologyRefreshFuture.get();
            try {
                scheduledFuture.cancel(false);
                this.clusterTopologyRefreshFuture.set(null);
            }
            catch (Exception e) {
                logger.debug("Could not unschedule Cluster topology refresh", (Throwable)e);
            }
        }
        super.shutdown(quietPeriod, timeout, timeUnit);
    }

    public void setOptions(ClusterClientOptions clientOptions) {
        super.setOptions(clientOptions);
    }

    protected RedisURI getFirstUri() {
        RedisClusterClient.assertNotEmpty(this.initialUris);
        Iterator<RedisURI> iterator = this.initialUris.iterator();
        return iterator.next();
    }

    protected Supplier<SocketAddress> getSocketAddressSupplier(Function<Partitions, Collection<RedisClusterNode>> sortFunction) {
        LettuceAssert.notNull(sortFunction, "Sort function must not be null");
        RoundRobinSocketAddressSupplier socketAddressSupplier = new RoundRobinSocketAddressSupplier(this.partitions, sortFunction, this.clientResources);
        return () -> {
            if (this.partitions.isEmpty()) {
                SocketAddress socketAddress = SocketAddressResolver.resolve(this.getFirstUri(), this.clientResources.dnsResolver());
                logger.debug("Resolved SocketAddress {} using {}", (Object)socketAddress, (Object)this.getFirstUri());
                return socketAddress;
            }
            return socketAddressSupplier.get();
        };
    }

    protected Iterable<RedisURI> getInitialUris() {
        return this.initialUris;
    }

    protected void forEachClusterConnection(Consumer<StatefulRedisClusterConnectionImpl<?, ?>> function) {
        this.forEachCloseable(input -> input instanceof StatefulRedisClusterConnectionImpl, function);
    }

    protected void forEachClusterPubSubConnection(Consumer<StatefulRedisClusterPubSubConnectionImpl<?, ?>> function) {
        this.forEachCloseable(input -> input instanceof StatefulRedisClusterPubSubConnectionImpl, function);
    }

    protected <T extends Closeable> void forEachCloseable(Predicate<? super Closeable> selector, Consumer<T> function) {
        for (Closeable c : this.closeableResources) {
            if (!selector.test(c)) continue;
            function.accept(c);
        }
    }

    protected Iterable<RedisURI> getTopologyRefreshSource() {
        Iterable<RedisURI> seed;
        boolean initialSeedNodes;
        boolean bl = initialSeedNodes = !this.useDynamicRefreshSources();
        if (initialSeedNodes || this.partitions == null || this.partitions.isEmpty()) {
            seed = this.initialUris;
        } else {
            ArrayList<RedisURI> uris = new ArrayList<RedisURI>();
            for (RedisClusterNode partition : TopologyComparators.sortByUri(this.partitions)) {
                uris.add(partition.getUri());
            }
            seed = uris;
        }
        return seed;
    }

    protected boolean useDynamicRefreshSources() {
        if (this.getClusterClientOptions() != null) {
            ClusterTopologyRefreshOptions topologyRefreshOptions = this.getClusterClientOptions().getTopologyRefreshOptions();
            return topologyRefreshOptions.useDynamicRefreshSources();
        }
        return true;
    }

    protected RedisCodec<String, String> newStringStringCodec() {
        return StringCodec.UTF8;
    }

    ClusterClientOptions getClusterClientOptions() {
        if (this.getOptions() instanceof ClusterClientOptions) {
            return (ClusterClientOptions)this.getOptions();
        }
        return null;
    }

    boolean expireStaleConnections() {
        return this.getClusterClientOptions() == null || this.getClusterClientOptions().isCloseStaleConnections();
    }

    private static <K, V> void assertNotNull(RedisCodec<K, V> codec) {
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
    }

    private static void assertNotEmpty(Iterable<RedisURI> redisURIs) {
        LettuceAssert.notNull(redisURIs, "RedisURIs must not be null");
        LettuceAssert.isTrue(redisURIs.iterator().hasNext(), "RedisURIs must not be empty");
    }

    private static RedisURI assertNotNull(RedisURI redisURI) {
        LettuceAssert.notNull(redisURI, "RedisURI must not be null");
        return redisURI;
    }

    private static void assertNotNull(ClientResources clientResources) {
        LettuceAssert.notNull(clientResources, "ClientResources must not be null");
    }

    private class NodeConnectionFactoryImpl
    implements NodeConnectionFactory {
        private NodeConnectionFactoryImpl() {
        }

        @Override
        public <K, V> StatefulRedisConnection<K, V> connectToNode(RedisCodec<K, V> codec, SocketAddress socketAddress) {
            return RedisClusterClient.this.connectToNode(codec, socketAddress.toString(), null, () -> socketAddress);
        }

        @Override
        public <K, V> ConnectionFuture<StatefulRedisConnection<K, V>> connectToNodeAsync(RedisCodec<K, V> codec, SocketAddress socketAddress) {
            return RedisClusterClient.this.connectToNodeAsync(codec, socketAddress.toString(), null, () -> socketAddress);
        }
    }
}

