/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.internal.HostAndPort;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class RedisClusterURIUtil {
    public static List<RedisURI> toRedisURIs(URI uri) {
        RedisURI redisURI = RedisURI.create(uri);
        String[] parts = redisURI.getHost().split("\\,");
        ArrayList<RedisURI> redisURIs = new ArrayList<RedisURI>(parts.length);
        for (String part : parts) {
            HostAndPort hostAndPort = HostAndPort.parse(part);
            RedisURI nodeUri = RedisURI.create(hostAndPort.getHostText(), hostAndPort.hasPort() ? hostAndPort.getPort() : redisURI.getPort());
            RedisClusterURIUtil.applyUriConnectionSettings(redisURI, nodeUri);
            redisURIs.add(nodeUri);
        }
        return redisURIs;
    }

    static void applyUriConnectionSettings(RedisURI from, RedisURI to) {
        if (from.getPassword() != null && from.getPassword().length != 0) {
            to.setPassword(new String(from.getPassword()));
        }
        to.setTimeout(from.getTimeout());
        to.setUnit(from.getUnit());
        to.setSsl(from.isSsl());
        to.setStartTls(from.isStartTls());
        to.setVerifyPeer(from.isVerifyPeer());
    }
}

