/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.ScoredValue;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.output.ListSubscriber;
import com.lambdaworks.redis.output.OutputFactory;
import com.lambdaworks.redis.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ScoredValueListOutput<K, V>
extends CommandOutput<K, V, List<ScoredValue<V>>>
implements StreamingOutput<ScoredValue<V>> {
    private boolean initialized;
    private StreamingOutput.Subscriber<ScoredValue<V>> subscriber;
    private V value;

    public ScoredValueListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<ScoredValue<V>>)ListSubscriber.instance());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.subscriber.onNext((Collection)this.output, new ScoredValue<V>(score, this.value));
        this.value = null;
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<ScoredValue<V>> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<ScoredValue<V>> getSubscriber() {
        return this.subscriber;
    }
}

